/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader, int n) {
        super(reader);
        this.buf = new char[n];
        this.pos = n;
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (this.pos < this.buf.length) {
                char c = this.buf[this.pos++];
                Object var3_4 = null;
                return c;
            }
            int n = super.read();
            Object var3_5 = null;
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (n2 <= 0) {
                return 0;
            }
            int n3 = this.buf.length - this.pos;
            if (n3 > 0) {
                if (n2 < n3) {
                    n3 = n2;
                }
                System.arraycopy(this.buf, this.pos, cArray, n, n3);
                this.pos += n3;
                n += n3;
                n2 -= n3;
            }
            if (n2 <= 0) return n3;
            if ((n2 = super.read(cArray, n, n2)) != -1) return n3 + n2;
            if (n3 == 0) {
                return -1;
            }
            int n4 = n3;
            return n4;
        }
    }

    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (this.pos == 0) {
                throw new IOException("Pushback buffer overflow");
            }
            this.buf[--this.pos] = (char)n;
            return;
        }
    }

    public void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (n2 > this.pos) {
                throw new IOException("Pushback buffer overflow");
            }
            this.pos -= n2;
            System.arraycopy(cArray, n, this.buf, this.pos, n2);
            return;
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            boolean bl = this.pos < this.buf.length || super.ready();
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.buf = null;
    }
}

