/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public class ServerSocket {
    private SocketImpl impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
    private static SocketImplFactory factory;

    private ServerSocket() throws IOException {
    }

    public ServerSocket(int n) throws IOException {
        this(n, 50, null);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + n);
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
            this.impl.create(true);
            if (inetAddress == null) {
                inetAddress = InetAddress.anyLocalAddress;
            }
            this.impl.bind(inetAddress, n);
            this.impl.listen(n2);
            return;
        }
        catch (SecurityException securityException) {
            this.impl.close();
            throw securityException;
        }
        catch (IOException iOException) {
            this.impl.close();
            throw iOException;
        }
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public Socket accept() throws IOException {
        Socket socket = new Socket();
        this.implAccept(socket);
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        SocketImpl socketImpl = socket.impl;
        try {
            socket.impl = null;
            socketImpl.address = new InetAddress();
            socketImpl.fd = new FileDescriptor();
            this.impl.accept(socketImpl);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkAccept(socketImpl.getInetAddress().getHostAddress(), socketImpl.getPort());
            }
        }
        catch (IOException iOException) {
            socketImpl.reset();
            socket.impl = socketImpl;
            throw iOException;
        }
        catch (SecurityException securityException) {
            socketImpl.reset();
            socket.impl = socketImpl;
            throw securityException;
        }
        socket.impl = socketImpl;
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws IOException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public String toString() {
        return "ServerSocket[addr=" + this.impl.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }
}

