/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Identity
implements Principal,
Serializable {
    private String name;
    private PublicKey publicKey;
    String info = "No further information available.";
    IdentityScope scope;
    Vector certificates;

    protected Identity() {
        this("restoring...");
    }

    public Identity(String string, IdentityScope identityScope) throws KeyManagementException {
        this(string);
        this.scope = identityScope;
    }

    public Identity(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) throws KeyManagementException {
        this.check("set.public.key");
        this.publicKey = publicKey;
        this.certificates = new Vector();
    }

    public void setInfo(String string) {
        this.check("set.info");
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        this.check("add.certificate");
        if (this.certificates == null) {
            this.certificates = new Vector();
        }
        if (this.publicKey != null) {
            if (!this.keyEquals(this.publicKey, certificate.getPublicKey())) {
                throw new KeyManagementException("public key different from cert public key");
            }
        } else {
            this.publicKey = certificate.getPublicKey();
        }
        this.certificates.addElement(certificate);
    }

    private boolean keyEquals(Key key, Key key2) {
        if (key.getFormat().equalsIgnoreCase(key2.getFormat())) {
            return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
        }
        return false;
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        this.check("remove.certificate");
        if (this.certificates != null) {
            this.certificates.removeElement(certificate);
        }
    }

    public Certificate[] certificates() {
        if (this.certificates == null) {
            return new Certificate[0];
        }
        int n = this.certificates.size();
        Object[] objectArray = new Certificate[n];
        this.certificates.copyInto(objectArray);
        return objectArray;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            if (identity.getScope() == this.scope && identity.getName().equals(this.name)) {
                return true;
            }
            return this.identityEquals(identity);
        }
        return false;
    }

    protected boolean identityEquals(Identity identity) {
        return this.name.equals(identity.name) && this.publicKey.equals(identity.publicKey);
    }

    String fullName() {
        String string = this.name;
        if (this.scope != null) {
            string = String.valueOf(string) + "." + this.scope.getName();
        }
        return string;
    }

    public String toString() {
        this.check("print");
        String string = this.name;
        if (this.scope != null) {
            string = String.valueOf(string) + "[" + this.scope.getName() + "]";
        }
        return string;
    }

    public String toString(boolean bl) {
        String string = this.toString();
        if (bl) {
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + this.printKeys();
            string = String.valueOf(string) + "\n" + this.printCertificates();
            string = this.info != null ? String.valueOf(string) + "\n\t" + this.info : String.valueOf(string) + "\n\tno additional information available.";
        }
        return string;
    }

    String printKeys() {
        String string = "";
        string = this.publicKey != null ? "\tpublic key initialized" : "\tno public key";
        return string;
    }

    String printCertificates() {
        String string = "";
        if (this.certificates == null) {
            return "\tno certificates";
        }
        string = String.valueOf(string) + "\tcertificates: \n";
        Enumeration enumeration = this.certificates.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Certificate certificate = (Certificate)enumeration.nextElement();
            string = String.valueOf(string) + "\tcertificate " + n++ + "\tfor  : " + certificate.getPrincipal() + "\n";
            string = String.valueOf(string) + "\t\t\tfrom : " + certificate.getGuarantor() + "\n";
        }
        return string;
    }

    public int hashCode() {
        String string = this.name;
        if (this.scope != null) {
            string = String.valueOf(string) + this.scope.getName();
        }
        return string.hashCode();
    }

    void check(String string) {
        Identity.staticCheck(String.valueOf(this.getClass().getName()) + "." + string + "." + this.fullName());
    }

    static void staticCheck(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }
}

