/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Graphics;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11OffScreenImage;

public abstract class MComponentPeer
implements ComponentPeer,
UpdateClient {
    Component target;
    int pData;
    int cursorSet;
    private boolean repaintPending;
    private Rectangle repaintRect;

    abstract void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    void EFcreate(MComponentPeer mComponentPeer, Object object, int n) {
    }

    void EF1create(MComponentPeer mComponentPeer, int n) {
    }

    native void pInitialize();

    native void pShow();

    native void pHide();

    native void pEnable();

    native void pDisable();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pMakeCursorVisible();

    native Point pGetLocationOnScreen();

    native void pSetForeground(Color var1);

    native void pSetBackground(Color var1);

    native void pSetFont(Font var1);

    void initialize() {
        Font font;
        if (!this.target.isVisible()) {
            this.hide();
        }
        this.pInitialize();
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
        Cursor cursor = this.target.getCursor();
        this.setCursor(cursor);
        if (cursor == null) {
            this.cursorSet = 1;
        }
        if (!this.target.isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = this.target.getBounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.show();
        }
    }

    public void init(Component component, Object object) {
        this.target = component;
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        if (component instanceof MEmbeddedFrame) {
            MEmbeddedFrame mEmbeddedFrame = (MEmbeddedFrame)component;
            this.EFcreate(mComponentPeer, object, mEmbeddedFrame.handle);
        } else {
            this.create(mComponentPeer, object);
        }
        this.initialize();
    }

    MComponentPeer(Component component, Object object) {
        this.init(component, object);
    }

    MComponentPeer() {
    }

    public void init(Component component) {
        Object object;
        this.target = component;
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        if (component instanceof MEmbeddedFrame) {
            object = (MEmbeddedFrame)component;
            this.EF1create(mComponentPeer, ((MEmbeddedFrame)object).handle);
        } else {
            this.create(mComponentPeer);
        }
        if (container != null && container instanceof ScrollPane) {
            object = (MScrollPanePeer)mComponentPeer;
            ((MScrollPanePeer)object).setScrollChild(this);
        }
        this.initialize();
    }

    MComponentPeer(Component component) {
        this.init(component);
    }

    private synchronized void addRepaintArea(int n, int n2, int n3, int n4) {
        if (!this.repaintPending) {
            this.repaintPending = true;
            this.repaintRect = new Rectangle(n, n2, n3, n4);
            return;
        }
        this.repaintRect = this.repaintRect.union(new Rectangle(n, n2, n3, n4));
    }

    public void setForeground(Color color) {
        this.pSetForeground(color);
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            int n = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            while (n2 < n) {
                Color color2;
                ComponentPeer componentPeer;
                if (componentArray[n2] != null && (componentPeer = componentArray[n2].getPeer()) != null && color != (color2 = componentArray[n2].getForeground())) {
                    componentPeer.setForeground(color2);
                }
                ++n2;
            }
        }
    }

    public void setBackground(Color color) {
        this.pSetBackground(color);
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            int n = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            while (n2 < n) {
                Color color2;
                ComponentPeer componentPeer;
                if (componentArray[n2] != null && (componentPeer = componentArray[n2].getPeer()) != null && color != (color2 = componentArray[n2].getBackground())) {
                    componentPeer.setBackground(color2);
                }
                ++n2;
            }
        }
    }

    public void setFont(Font font) {
        this.pSetFont(font);
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            int n = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            while (n2 < n) {
                Font font2;
                ComponentPeer componentPeer;
                if (componentArray[n2] != null && (componentPeer = componentArray[n2].getPeer()) != null && font != (font2 = componentArray[n2].getFont())) {
                    componentPeer.setFont(font);
                }
                ++n2;
            }
        }
    }

    public native void setCursor(Cursor var1);

    public boolean isFocusTraversable() {
        return false;
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public int updatePriority() {
        return 5;
    }

    public void updateClient(Object object) {
        if (this.target.getPeer() != null) {
            Rectangle rectangle = null;
            MComponentPeer mComponentPeer = this;
            synchronized (mComponentPeer) {
                if (this.repaintPending) {
                    rectangle = this.repaintRect;
                    this.repaintPending = false;
                }
            }
            if (rectangle != null) {
                this.postEvent(new PaintEvent(this.target, 801, rectangle));
            }
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.addRepaintArea(n, n2, n3, n4);
        ScreenUpdater.updater.notify(this, l);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.paint(graphics);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.update(graphics);
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        Color color = this.target.getBackground();
        Color color2 = this.target.getForeground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(color2);
        graphics.setFont(this.target.getFont());
        this.target.print(graphics);
    }

    native void nativeHandleEvent(AWTEvent var1);

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 800: 
            case 801: {
                Graphics graphics = null;
                Rectangle rectangle = ((PaintEvent)aWTEvent).getUpdateRect();
                Object object = this.target.getTreeLock();
                synchronized (object) {
                    graphics = this.target.getGraphics();
                    if (graphics == null) {
                        Object var6_6 = null;
                        return;
                    }
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (n == 800) {
                    this.target.paint(graphics);
                } else {
                    this.target.update(graphics);
                }
                graphics.dispose();
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Graphics getGraphics() {
        X11Graphics x11Graphics = new X11Graphics(this);
        ((Graphics)x11Graphics).setColor(this.target.getForeground());
        ((Graphics)x11Graphics).setFont(this.target.getFont());
        return x11Graphics;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new X11OffScreenImage(this.target, n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    public void dispose() {
        Object object = this.target.getTreeLock();
        synchronized (object) {
            ScreenUpdater.updater.removeClient(this);
            MToolkit.targetDisposedPeer(this.target, this);
            this.pDispose();
            return;
        }
    }

    public native void requestFocus();

    void postEvent(AWTEvent aWTEvent) {
        MToolkit.postEvent(aWTEvent);
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent(this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent(this.target, 801, new Rectangle(n, n2, n3, n4)));
    }

    public int getZOrderPosition() {
        Container container = this.target.getParent();
        if (container != null) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] == this.target) {
                    return n;
                }
                Object object = MToolkit.targetToPeer(componentArray[n2]);
                if (object != null && !(object instanceof LightweightPeer)) {
                    ++n;
                }
                ++n2;
            }
        }
        return -1;
    }

    void draw3DOval(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawArc(n, n2, n3, n4, 45, 180);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawArc(n, n2, n3, n4, 225, 180);
        graphics.setColor(color2);
    }

    void draw3DRect(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        graphics.setColor(color2);
    }

    void drawScrollbar(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color2 = graphics.getColor();
        double d = (double)(n2 - 2 * (n - 1)) / (double)Math.max(1, n4 - n3 + n6);
        int n7 = n + (int)(d * (double)(n5 - n3));
        int n8 = (int)(d * (double)n6);
        int n9 = n - 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (n2 < 3 * n9) {
            n8 = 0;
            n7 = 0;
            if (n2 < 2 * n9 + 2) {
                n9 = (n2 - 2) / 2;
            }
        } else if (n8 < 7) {
            n7 = Math.max(0, n7 - (7 - n8 >> 1));
            n8 = 7;
        }
        int n10 = n / 2;
        int n11 = n10 - n9 / 2;
        int n12 = n10 + n9 / 2;
        Color color3 = new Color((int)((double)color.getRed() * 0.85), (int)((double)color.getGreen() * 0.85), (int)((double)color.getBlue() * 0.85));
        graphics.setColor(color3);
        if (bl) {
            graphics.fillRect(0, 0, n2, n);
        } else {
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(color);
        if (n7 > 0) {
            if (bl) {
                graphics.fillRect(n7, 3, n8, n - 3);
            } else {
                graphics.fillRect(3, n7, n - 3, n8);
            }
        }
        nArray[0] = n10;
        nArray2[0] = 2;
        nArray[1] = n11;
        nArray2[1] = n9;
        nArray[2] = n12;
        nArray2[2] = n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        nArray2[0] = n2 - 2;
        nArray2[1] = n2 - n9;
        nArray2[2] = n2 - n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        Color color4 = color.brighter();
        graphics.setColor(color4);
        if (bl) {
            graphics.drawLine(1, n, n2 - 1, n);
            graphics.drawLine(n2 - 1, 1, n2 - 1, n);
            graphics.drawLine(1, n10, n9, n11);
            graphics.drawLine(n2 - n9, n11, n2 - n9, n12);
            graphics.drawLine(n2 - n9, n11, n2 - 2, n10);
        } else {
            graphics.drawLine(n, 1, n, n2 - 1);
            graphics.drawLine(1, n2 - 1, n, n2 - 1);
            graphics.drawLine(n10, 1, n11, n9);
            graphics.drawLine(n11, n2 - n9, n12, n2 - n9);
            graphics.drawLine(n11, n2 - n9, n10, n2 - 2);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7, 2, n7 + n8, 2);
                graphics.drawLine(n7, 2, n7, n - 3);
            } else {
                graphics.drawLine(2, n7, 2, n7 + n8);
                graphics.drawLine(2, n7, n - 3, n7);
            }
        }
        Color color5 = color.darker();
        graphics.setColor(color5);
        if (bl) {
            graphics.drawLine(0, 0, 0, n);
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.drawLine(n9, n11, n9, n12);
            graphics.drawLine(n9, n12, 1, n10);
            graphics.drawLine(n2 - 2, n10, n2 - n9, n12);
        } else {
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(n11, n9, n12, n9);
            graphics.drawLine(n12, n9, n10, 1);
            graphics.drawLine(n10, n2 - 2, n12, n2 - n9);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7 + n8, 2, n7 + n8, n - 2);
                graphics.drawLine(n7, n - 2, n7 + n8, n - 2);
            } else {
                graphics.drawLine(2, n7 + n8, n - 2, n7 + n8);
                graphics.drawLine(n - 2, n7, n - 2, n7 + n8);
            }
        }
        graphics.setColor(color2);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.target + "]";
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pShow();
            return;
        }
        this.pHide();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.pEnable();
            return;
        }
        this.pDisable();
    }

    public Point getLocationOnScreen() {
        return this.pGetLocationOnScreen();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Container container = this.target.getParent();
        if (container != null && container instanceof ScrollPane) {
            MScrollPanePeer mScrollPanePeer = (MScrollPanePeer)container.getPeer();
            if (!mScrollPanePeer.ignore) {
                this.pReshape(n, n2, n3, n4);
                mScrollPanePeer.childResized(n3, n4);
                return;
            }
        } else {
            this.pReshape(n, n2, n3, n4);
        }
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }
}

