/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MToolkit;

class MMenuItemPeer
implements MenuItemPeer {
    int pData;
    boolean isCheckbox = false;
    MenuItem target;
    boolean nativeCreated = false;

    native void createMenuItem(MMenuPeer var1);

    void create(MMenuPeer mMenuPeer) {
        if (mMenuPeer.nativeCreated) {
            this.createMenuItem(mMenuPeer);
            this.nativeCreated = true;
            this.setEnabled(this.target.isEnabled());
        }
    }

    protected MMenuItemPeer() {
    }

    MMenuItemPeer(MenuItem menuItem) {
        this.target = menuItem;
        MMenuPeer mMenuPeer = (MMenuPeer)MToolkit.targetToPeer(menuItem.getParent());
        this.create(mMenuPeer);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
            return;
        }
        this.disable();
    }

    public void setLabel(String string) {
        if (!this.nativeCreated) {
            return;
        }
        this.pSetLabel(string);
        MenuShortcut menuShortcut = this.target.getShortcut();
        this.setShortcut(menuShortcut != null ? menuShortcut.toString() : null);
    }

    public void setShortcut(String string) {
        if (this.nativeCreated) {
            this.pSetShortcut(string);
        }
    }

    native void pSetLabel(String var1);

    native void pSetShortcut(String var1);

    public void enable() {
        if (!this.nativeCreated) {
            return;
        }
        this.pEnable();
    }

    native void pEnable();

    public void disable() {
        if (!this.nativeCreated) {
            return;
        }
        this.pDisable();
    }

    native void pDisable();

    private void destroyNativeWidgetImpl() {
        if (this.nativeCreated) {
            this.pDispose();
            this.nativeCreated = false;
        }
    }

    void destroyNativeWidget() {
        this.destroyNativeWidgetImpl();
    }

    public void dispose() {
        this.destroyNativeWidgetImpl();
        MToolkit.targetDisposedPeer(this.target, this);
    }

    native void pDispose();

    void postEvent(AWTEvent aWTEvent) {
        MToolkit.postEvent(aWTEvent);
    }

    public void action(long l, int n) {
        this.postEvent(new ActionEvent(this.target, 1001, this.target.getActionCommand(), n));
    }
}

