/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.ByteToCharDefault;
import sun.io.CharacterEncoding;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class ByteToCharJISAutoDetect
extends ByteToCharConverter {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;
    private static final int SS2 = 142;
    private static final int SS3 = 143;
    private String SJISName = CharacterEncoding.getSJISName();
    private String convName;
    private ByteToCharConverter detectedConv;
    private ByteToCharConverter defaultConv;
    private static final byte[] maskTable1;
    private static final byte[] maskTable2;

    public ByteToCharJISAutoDetect() {
        try {
            this.defaultConv = ByteToCharConverter.getConverter((String)"8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.defaultConv = new ByteToCharDefault();
        }
        this.defaultConv.subChars = this.subChars;
        this.defaultConv.subMode = this.subMode;
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        this.badInputLength = 0;
        if (this.detectedConv != null) {
            return this.detectedConv.flush(cArray, n, n2);
        }
        return this.defaultConv.flush(cArray, n, n2);
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = 0;
        this.charOff = n3;
        this.byteOff = n;
        try {
            if (this.detectedConv == null) {
                int n6 = 0;
                int n7 = 0;
                byte by = 0;
                byte by2 = 0;
                boolean bl = false;
                int n8 = n;
                while (n8 < n2) {
                    by = 0;
                    by2 = 0;
                    int n9 = byArray[n8] & 0xFF;
                    if (n9 == 27) {
                        this.convName = "ISO2022JP";
                        break;
                    }
                    if (!bl && n9 < 128) {
                        if (this.charOff >= n4) {
                            throw new ConversionBufferFullException();
                        }
                        cArray[this.charOff++] = (char)n9;
                        ++this.byteOff;
                        ++n5;
                    } else {
                        bl = true;
                        by = maskTable1[n9];
                        if (n9 == 142) {
                            ++n7;
                        }
                        if (by != 0) {
                            if (n8 + 1 < n2) {
                                int n10;
                                int n11;
                                if ((n11 = by & (by2 = maskTable2[n10 = byArray[++n8] & 0xFF])) == 1) {
                                    this.convName = "EUC_JP";
                                    break;
                                }
                                if (n11 == 2 || n11 == 4 || ByteToCharJISAutoDetect.canBeSJIS1B(by) && by2 == 0) {
                                    this.convName = this.SJISName;
                                    break;
                                }
                                if (n9 == 143 && ByteToCharJISAutoDetect.canBeEUCJP(by2)) {
                                    if (n8 + 1 < n2) {
                                        int n12 = byArray[n8 + 1] & 0xFF;
                                        if (!ByteToCharJISAutoDetect.canBeEUCJP(maskTable2[n12])) {
                                            this.convName = this.SJISName;
                                        }
                                    } else {
                                        this.convName = this.SJISName;
                                    }
                                }
                                if (ByteToCharJISAutoDetect.canBeEUCKana(by, by2)) {
                                    ++n6;
                                }
                            } else if ((by & 4) != 0) {
                                this.convName = this.SJISName;
                                break;
                            }
                        }
                    }
                    ++n8;
                }
                if (this.convName == null) {
                    this.convName = n6 > 1 || n7 > 1 ? "EUC_JP" : this.SJISName;
                }
                if (this.convName != null) {
                    try {
                        this.detectedConv = ByteToCharConverter.getConverter((String)this.convName);
                        this.detectedConv.subChars = this.subChars;
                        this.detectedConv.subMode = this.subMode;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.detectedConv = null;
                        this.convName = null;
                    }
                }
            }
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw conversionBufferFullException;
        }
        catch (Exception exception) {
            this.detectedConv = this.defaultConv;
        }
        if (this.byteOff == n2) {
            return n5;
        }
        if (this.detectedConv != null) {
            try {
                n5 += this.detectedConv.convert(byArray, n + n5, n2, cArray, n3 + n5, n4);
            }
            finally {
                Object var9_13 = null;
                this.charOff = this.detectedConv.nextCharIndex();
                this.byteOff = this.detectedConv.nextByteIndex();
                this.badInputLength = this.detectedConv.badInputLength;
            }
        }
        try {
            n5 += this.defaultConv.convert(byArray, n + n5, n2, cArray, n3 + n5, n4);
        }
        finally {
            Object var9_15 = null;
            this.charOff = this.defaultConv.nextCharIndex();
            this.byteOff = this.defaultConv.nextByteIndex();
            this.badInputLength = this.defaultConv.badInputLength;
        }
        return n5;
    }

    public void reset() {
        if (this.detectedConv != null) {
            this.detectedConv.reset();
            this.detectedConv = null;
            this.convName = null;
        } else {
            this.defaultConv.reset();
        }
        this.byteOff = 0;
        this.charOff = 0;
    }

    public String getCharacterEncoding() {
        return "JISAutoDetect";
    }

    private static final boolean canBeSJIS1B(int n) {
        return (n & 4) != 0;
    }

    private static final boolean canBeEUCJP(int n) {
        return (n & 1) != 0;
    }

    private static final boolean canBeEUCKana(int n, int n2) {
        return (n & 8) != 0 && (n2 & 0x10) != 0;
    }

    static {
        byte[] byArray = new byte[256];
        byArray[129] = 2;
        byArray[130] = 2;
        byArray[131] = 2;
        byArray[132] = 2;
        byArray[133] = 2;
        byArray[134] = 2;
        byArray[135] = 2;
        byArray[136] = 2;
        byArray[137] = 2;
        byArray[138] = 2;
        byArray[139] = 2;
        byArray[140] = 2;
        byArray[141] = 2;
        byArray[142] = 3;
        byArray[143] = 3;
        byArray[144] = 2;
        byArray[145] = 2;
        byArray[146] = 2;
        byArray[147] = 2;
        byArray[148] = 2;
        byArray[149] = 2;
        byArray[150] = 2;
        byArray[151] = 2;
        byArray[152] = 2;
        byArray[153] = 2;
        byArray[154] = 2;
        byArray[155] = 2;
        byArray[156] = 2;
        byArray[157] = 2;
        byArray[158] = 2;
        byArray[159] = 2;
        byArray[161] = 5;
        byArray[162] = 5;
        byArray[163] = 5;
        byArray[164] = 13;
        byArray[165] = 5;
        byArray[166] = 5;
        byArray[167] = 5;
        byArray[168] = 5;
        byArray[169] = 5;
        byArray[170] = 5;
        byArray[171] = 5;
        byArray[172] = 5;
        byArray[173] = 5;
        byArray[174] = 5;
        byArray[175] = 5;
        byArray[176] = 5;
        byArray[177] = 5;
        byArray[178] = 5;
        byArray[179] = 5;
        byArray[180] = 5;
        byArray[181] = 5;
        byArray[182] = 5;
        byArray[183] = 5;
        byArray[184] = 5;
        byArray[185] = 5;
        byArray[186] = 5;
        byArray[187] = 5;
        byArray[188] = 5;
        byArray[189] = 5;
        byArray[190] = 5;
        byArray[191] = 5;
        byArray[192] = 5;
        byArray[193] = 5;
        byArray[194] = 5;
        byArray[195] = 5;
        byArray[196] = 5;
        byArray[197] = 5;
        byArray[198] = 5;
        byArray[199] = 5;
        byArray[200] = 5;
        byArray[201] = 5;
        byArray[202] = 5;
        byArray[203] = 5;
        byArray[204] = 5;
        byArray[205] = 5;
        byArray[206] = 5;
        byArray[207] = 5;
        byArray[208] = 5;
        byArray[209] = 5;
        byArray[210] = 5;
        byArray[211] = 5;
        byArray[212] = 5;
        byArray[213] = 5;
        byArray[214] = 5;
        byArray[215] = 5;
        byArray[216] = 5;
        byArray[217] = 5;
        byArray[218] = 5;
        byArray[219] = 5;
        byArray[220] = 5;
        byArray[221] = 5;
        byArray[222] = 5;
        byArray[223] = 5;
        byArray[224] = 3;
        byArray[225] = 3;
        byArray[226] = 3;
        byArray[227] = 3;
        byArray[228] = 3;
        byArray[229] = 3;
        byArray[230] = 3;
        byArray[231] = 3;
        byArray[232] = 3;
        byArray[233] = 3;
        byArray[234] = 3;
        byArray[235] = 3;
        byArray[236] = 3;
        byArray[237] = 3;
        byArray[238] = 3;
        byArray[239] = 3;
        byArray[240] = 3;
        byArray[241] = 3;
        byArray[242] = 3;
        byArray[243] = 3;
        byArray[244] = 3;
        byArray[245] = 3;
        byArray[246] = 3;
        byArray[247] = 3;
        byArray[248] = 3;
        byArray[249] = 3;
        byArray[250] = 3;
        byArray[251] = 3;
        byArray[252] = 3;
        byArray[253] = 1;
        byArray[254] = 1;
        maskTable1 = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[64] = 2;
        byArray2[65] = 2;
        byArray2[66] = 2;
        byArray2[67] = 2;
        byArray2[68] = 2;
        byArray2[69] = 2;
        byArray2[70] = 2;
        byArray2[71] = 2;
        byArray2[72] = 2;
        byArray2[73] = 2;
        byArray2[74] = 2;
        byArray2[75] = 2;
        byArray2[76] = 2;
        byArray2[77] = 2;
        byArray2[78] = 2;
        byArray2[79] = 2;
        byArray2[80] = 2;
        byArray2[81] = 2;
        byArray2[82] = 2;
        byArray2[83] = 2;
        byArray2[84] = 2;
        byArray2[85] = 2;
        byArray2[86] = 2;
        byArray2[87] = 2;
        byArray2[88] = 2;
        byArray2[89] = 2;
        byArray2[90] = 2;
        byArray2[91] = 2;
        byArray2[92] = 2;
        byArray2[93] = 2;
        byArray2[94] = 2;
        byArray2[95] = 2;
        byArray2[96] = 2;
        byArray2[97] = 2;
        byArray2[98] = 2;
        byArray2[99] = 2;
        byArray2[100] = 2;
        byArray2[101] = 2;
        byArray2[102] = 2;
        byArray2[103] = 2;
        byArray2[104] = 2;
        byArray2[105] = 2;
        byArray2[106] = 2;
        byArray2[107] = 2;
        byArray2[108] = 2;
        byArray2[109] = 2;
        byArray2[110] = 2;
        byArray2[111] = 2;
        byArray2[112] = 2;
        byArray2[113] = 2;
        byArray2[114] = 2;
        byArray2[115] = 2;
        byArray2[116] = 2;
        byArray2[117] = 2;
        byArray2[118] = 2;
        byArray2[119] = 2;
        byArray2[120] = 2;
        byArray2[121] = 2;
        byArray2[122] = 2;
        byArray2[123] = 2;
        byArray2[124] = 2;
        byArray2[125] = 2;
        byArray2[126] = 2;
        byArray2[128] = 2;
        byArray2[129] = 2;
        byArray2[130] = 2;
        byArray2[131] = 2;
        byArray2[132] = 2;
        byArray2[133] = 2;
        byArray2[134] = 2;
        byArray2[135] = 2;
        byArray2[136] = 2;
        byArray2[137] = 2;
        byArray2[138] = 2;
        byArray2[139] = 2;
        byArray2[140] = 2;
        byArray2[141] = 2;
        byArray2[142] = 2;
        byArray2[143] = 2;
        byArray2[144] = 2;
        byArray2[145] = 2;
        byArray2[146] = 2;
        byArray2[147] = 2;
        byArray2[148] = 2;
        byArray2[149] = 2;
        byArray2[150] = 2;
        byArray2[151] = 2;
        byArray2[152] = 2;
        byArray2[153] = 2;
        byArray2[154] = 2;
        byArray2[155] = 2;
        byArray2[156] = 2;
        byArray2[157] = 2;
        byArray2[158] = 2;
        byArray2[159] = 2;
        byArray2[160] = 2;
        byArray2[161] = 23;
        byArray2[162] = 23;
        byArray2[163] = 23;
        byArray2[164] = 23;
        byArray2[165] = 23;
        byArray2[166] = 23;
        byArray2[167] = 23;
        byArray2[168] = 23;
        byArray2[169] = 23;
        byArray2[170] = 23;
        byArray2[171] = 23;
        byArray2[172] = 23;
        byArray2[173] = 23;
        byArray2[174] = 23;
        byArray2[175] = 23;
        byArray2[176] = 23;
        byArray2[177] = 23;
        byArray2[178] = 23;
        byArray2[179] = 23;
        byArray2[180] = 23;
        byArray2[181] = 23;
        byArray2[182] = 23;
        byArray2[183] = 23;
        byArray2[184] = 23;
        byArray2[185] = 23;
        byArray2[186] = 23;
        byArray2[187] = 23;
        byArray2[188] = 23;
        byArray2[189] = 23;
        byArray2[190] = 23;
        byArray2[191] = 23;
        byArray2[192] = 23;
        byArray2[193] = 23;
        byArray2[194] = 23;
        byArray2[195] = 23;
        byArray2[196] = 23;
        byArray2[197] = 23;
        byArray2[198] = 23;
        byArray2[199] = 23;
        byArray2[200] = 23;
        byArray2[201] = 23;
        byArray2[202] = 23;
        byArray2[203] = 23;
        byArray2[204] = 23;
        byArray2[205] = 23;
        byArray2[206] = 23;
        byArray2[207] = 23;
        byArray2[208] = 23;
        byArray2[209] = 23;
        byArray2[210] = 23;
        byArray2[211] = 23;
        byArray2[212] = 23;
        byArray2[213] = 23;
        byArray2[214] = 23;
        byArray2[215] = 23;
        byArray2[216] = 23;
        byArray2[217] = 23;
        byArray2[218] = 23;
        byArray2[219] = 23;
        byArray2[220] = 23;
        byArray2[221] = 23;
        byArray2[222] = 23;
        byArray2[223] = 23;
        byArray2[224] = 19;
        byArray2[225] = 19;
        byArray2[226] = 19;
        byArray2[227] = 19;
        byArray2[228] = 19;
        byArray2[229] = 19;
        byArray2[230] = 19;
        byArray2[231] = 19;
        byArray2[232] = 19;
        byArray2[233] = 19;
        byArray2[234] = 19;
        byArray2[235] = 19;
        byArray2[236] = 19;
        byArray2[237] = 19;
        byArray2[238] = 19;
        byArray2[239] = 19;
        byArray2[240] = 19;
        byArray2[241] = 19;
        byArray2[242] = 19;
        byArray2[243] = 19;
        byArray2[244] = 3;
        byArray2[245] = 3;
        byArray2[246] = 3;
        byArray2[247] = 3;
        byArray2[248] = 3;
        byArray2[249] = 3;
        byArray2[250] = 3;
        byArray2[251] = 3;
        byArray2[252] = 3;
        byArray2[253] = 1;
        byArray2[254] = 1;
        maskTable2 = byArray2;
    }
}

