
# This is a Makefile to produce an MRTG configration file for Juniper routers
# Dave Plonka <plonka@doit.wisc.edu>, Jun 15 2003

# { CONFIGURATION SECTION BEGIN ################################################

SHELL = /usr/bin/ksh
perl = /usr/bin/perl
rrdbin = /usr/local/rrdtool-1.0.39/bin

juniper_routers = router1 router2
community = public

# } CONFIGURATION SECTION END ##################################################

all: junipers.cfg

junipers.cfg: HCInterfaceTemplate.pl
	cfgmaker --global="WorkDir: $$PWD" \
	--global='LogFormat: rrdtool' \
	--global='PathAdd: $(rrdbin)' \
	--global='RunAsDaemon: Yes' \
	--global='Interval: 5' \
	--ifref=name \
	--if-template=HCInterfaceTemplate.pl \
	--community=$(community) \
	--snmp-options=:::::2 $(juniper_routers) \
	--output=$@

.SUFFIXES: .rrd .xml

.rrd.xml:
	rrdtool dump $< > $@ || rm -f $@
