/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef METER_H
#define METER_H

#include <qpixmap.h>
#include <qpainter.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qobject.h>

#include <qfileinfo.h>
class Meter : public QObject
{
Q_OBJECT
public:

  Meter(int ix,int iy,int iw,int ih);
  Meter();
  virtual ~Meter();
  int getX();
  int getY();
  int getWidth();
  int getHeight();

  void setSize(int ix, int iy, int iw, int ih);

  virtual void setMax( int ){}
  virtual void setMin( int ){}

  void setThemePath( QString );

  virtual void mUpdate(QPainter *)=0 ;

  virtual void setValue(int){}
  virtual void setValue(QString){}


protected: // Protected attributes
  int x;
  int y;
  int width;
  int height;
  QString themePath;

};
#endif // METER_H
