/***************************************************************************
                          sitemanagerdb.cpp  -  description
                             -------------------
    begin                : tis mar 12 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qfile.h>
#include <qxml.h>
#include <qtextstream.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "sitemanagerdb.h"
#include "kbeartags.h"
#include "kbeardomhelper.h"
#include "resource.h"

using namespace KBear;
//-----------------------------------------------
SiteManagerDB::SiteManagerDB()
	:	DCOPObject("SiteManagerDBInterface"),
		m_oldSiteManagerFile( QString::null ),
		m_encoding( KGlobal::locale()->encoding() ),
		m_private( new SiteManagerDBSignaler(this) )
//		m_dockWindow( 0L )
		
 {
	kapp->dcopClient()->setDefaultObject( objId() );
	// create the system tray icon
//	m_dockWindow = new KSystemTray( kapp->mainWidget(), "SiteManagerDockWindow" );
//	m_dockWindow->setPixmap( KGlobal::iconLoader()->loadIcon("kbearsitemanager", KIcon::Small ) );

	/*
	First we do a little check so sitemanager.xml been installed properly
	If the installation failed somehow it's probably by wrong environment variables.
	In that case we warn the user.
	*/		
	m_siteManagerFile = locateLocal( "data", "kbear/sitemanager.xml" );
	bool found = false;
	if( ! QFile::exists( m_siteManagerFile ) ) {
		m_oldSiteManagerFile = locateLocal( "data", "kbear/sitemanager" );
		if( ! QFile::exists( m_oldSiteManagerFile ) ) {
			m_oldSiteManagerFile = locateLocal( "data", "kbear/sitemanager_1_3" );
			if( ! QFile::exists( m_oldSiteManagerFile ) )
				m_oldSiteManagerFile = QString::null;				
		}
		m_siteManagerFile = locate( "data", "kbear/sitemanager.xml" );
		if( ! QFile::exists( m_siteManagerFile ) )
			kdError()<<"File open error ! File: sitemanager.xml doesn't exist!"<<endl;
		else {
			found = true;
		}
	}
	else
		found = true;
	if( found ) {
		QFile file( m_siteManagerFile );
		file.open(IO_ReadOnly);
		if( ! m_siteDataBase.setContent( &file ) )
			kdError()<<QString("Parse Error: Parsing error for file %1" ).arg( m_siteManagerFile )<<endl;
		else
			m_encoding = encoding();
	}

	makeValidDomTree();  // we have to make sure that we have a valid dom document

	// Even if errors we ignore it an continue with an empty file
	m_siteManagerFile = locateLocal( "data", "kbear/sitemanager.xml" );
	save(); // save it in $HOME/$KDEDIR/share/apps/kbear
	QByteArray data;
	emitDCOPSignal("initialize()",data);

	if( ! m_oldSiteManagerFile.isNull() ) {
		QDataStream arg( data, IO_WriteOnly );
		arg << m_oldSiteManagerFile;
		emitDCOPSignal("importOldSitemanager(QString)",data);
	}

	QObject::connect( m_private->timer(), SIGNAL( timeout() ), m_private, SLOT( slotTimeout() ) );
	m_private->m_timer.start( 30000 );
//	if( kapp->isRestored() ) {
	KConfig c( "kbearsitemanagerrc" );
//	showSystemTrayIcon( c.readBoolEntry( "ShowSysemTrayIcon", true ) );
	setPlugInKonq( c.readBoolEntry( "PlugInKonq", false ) );
//	}
}
//-----------------------------------------------
SiteManagerDB::~SiteManagerDB(){
	delete m_private;
/*
	if( m_dockWindow )
		delete m_dockWindow;
*/
}
//-----------------------------------------------
bool SiteManagerDB::ping() {
	m_private->m_gotPing = true;
	return true;
}
//-----------------------------------------------
void SiteManagerDB::regReferer() {
/* We don't use this for now
		m_referers.push_back( kapp->dcopClient()->senderId() );
*/
}
//-----------------------------------------------
void SiteManagerDB::unregReferer( const QCString& /*referer*/ ) {
/* We don't use this for now
	QValueList<QCString>::Iterator it = m_referers.find( referer );
	if( it == m_referers.end() ) {
		kdWarning()<<referer<<" not registered count="<<m_referers.count()<<endl;
	}
	else
		m_referers.remove( it );
	if( m_referers.isEmpty() ) {
		kapp->quit();
	}
*/
}
//-----------------------------------------------
void SiteManagerDB::unregReferer() {
/* We don't use this for now
	unregReferer( kapp->dcopClient()->senderId() );
*/
}
//-----------------------------------------------
QDomNode SiteManagerDB::findSite( const SiteInfo& site ) {
	QDomElement parent = findParent( site.parent() );
	return KBearDomHelper::findNodeByAttribute( parent, TAG_SITE, ATT_LABEL, site.label() );
}
//-----------------------------------------------
QDomNode SiteManagerDB::findGroup( const Group& group ) {
	QDomElement parent = findParent( group.parent() );
	return KBearDomHelper::findNodeByAttribute( parent, TAG_GROUP, ATT_LABEL, group.label() );
}
//-----------------------------------------------
QDomElement SiteManagerDB::findParent( const QString& parentStr ) {
	QDomElement parent = m_siteDataBase.documentElement();
	QDomNodeList list = m_siteDataBase.documentElement().childNodes();
	QStringList parentStrList = QStringList::split( "/", parentStr );
	for( QStringList::Iterator it = parentStrList.begin(); it != parentStrList.end(); ++it ) {
		for( unsigned int j = 0; j < list.length(); j++ ) {
			if( list.item( j ).toElement().tagName() == TAG_GROUP && list.item( j ).toElement().attribute(ATT_LABEL) == (*it) ) {
				parent = list.item( j ).toElement();
				list = list.item( j ).childNodes();
				j = list.length();
			}
		}
	}
	return parent;
}
//-----------------------------------------------
void SiteManagerDB::saveSite( SiteInfo site ) {
	if( site.label().isEmpty() || site.label().isNull() )  // we don't want an empty label
		site.setLabel( i18n( "No Name" ) );

	if( ! addSite( site ) )
			return;

	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site;
	emitDCOPSignal( "newSite(SiteInfo)", data );
}
//-----------------------------------------------
bool SiteManagerDB::addSite( SiteInfo& site ) {
	QDomElement parent;
	if( site.parent().isNull() )
		parent = m_siteDataBase.documentElement();
	else
		parent = findParent( site.parent() );
	if( parent.isNull() ) // wasn't able to set parent node
		return false;
	addSite( parent, site );
	return true;
}
//-----------------------------------------------
void SiteManagerDB::addSite( QDomElement parentNode, SiteInfo& site ) {
	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	QDomNodeList list = parentNode.childNodes();
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = site.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( ! KBearDomHelper::findNodeByAttribute( parentNode, ATT_LABEL, ATT_LABEL, result ).isNull() )
				exist = true;
		}

	}while( exist );	

	site.setLabel( result );
	QDomElement element = KBearDomHelper::addEmptyElement( m_siteDataBase, parentNode, TAG_SITE );
	element.setAttribute( ATT_LABEL, site.label() );
	KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_PROTOCOL, site.protocol() );
	KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_HOST, site.host() );
	KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_PORT, QString::number( site.port() ) );
	if( site.user() != QString::null )
		KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_USER, site.user() );
	if( site.pass() != QString::null )
		KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_PASS, site.pass() );
	if( !site.remotePath().isNull() )
		KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_REMOTE_PATH, site.remotePath() );
	if( !site.localPath().isNull() )
		KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_LOCAL_PATH, site.localPath() );
	if( !site.description().isNull() )
		KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_DESCRIPTION, site.description() );
	if( !( site.listCommand() == "list -a" || site.listCommand().isEmpty() ) )
		KBearDomHelper::addTextNode( m_siteDataBase, element, TAG_LIST_COMMAND, site.listCommand() );
	if( site.anonym() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_ANONYMOUS );
	if( ! site.passiveMode() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_DISABLE_PASV );
	if( ! site.extendedPassiveMode() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_DISABLE_EPASV );
/* Removed since this is now a globally option
	if( ! site.binaryMode() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_ASCII );
*/
	if( ! site.enableLog() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_DISABLE_LOG );
	if( site.markPartial() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_MARK_PARTIAL );
/* Removed since this is now a globally option
	if( site.queue() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_QUEUE );
*/
	if( site.singleConnection() )
		KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_SINGLE_CONNECTION );
	if( site.autoReconnect() ) {
		QDomElement tmpElement = KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_AUTO_RECONNECT );
		tmpElement.setAttribute(ATT_SLEEP, QString::number( site.reconnectTime() ) );
		tmpElement.setAttribute(ATT_COUNT, QString::number( site.numOfRetries() ) );
	}
	QDomElement tmpElement = KBearDomHelper::addEmptyElement( m_siteDataBase, element, TAG_FILESYS_ENCODING );
	tmpElement.setAttribute(ATT_ENCODING, site.fileSysEncoding() );
}
//-----------------------------------------------
void SiteManagerDB::removeSite( SiteInfo site ) {
	QDomNode siteNode = findSite( site );
	if( siteNode.isNull() )
		return;

	QDomNode parent = siteNode.parentNode();
	parent.removeChild( siteNode );
	
	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );;
	arg << site;
	emitDCOPSignal( "siteRemoved(SiteInfo)", data );
}
//-----------------------------------------------
void SiteManagerDB::moveSite( SiteInfo site, QString newParent ) {
	QDomNode siteNode = findSite( site );
	if( siteNode.isNull() )
		return;

	// we need to save original name
	QString oldName = site.label();

	QDomNode oldParentNode = siteNode.parentNode();
	QDomNode newParentNode = findParent( newParent );
	if( oldParentNode == newParentNode )
		return;
	QString oldParent = getFullPath ( oldParentNode.toElement() );
	QDomNode clonedNode = siteNode.cloneNode( true );
	oldParentNode.removeChild( siteNode );

	// we have to check if the name exist, if so rename
	QDomNodeList list = newParentNode.childNodes();
	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = site.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( list.item( i ).toElement().attribute(ATT_LABEL) == result )
				exist = true;
		}

	}while( exist );	

	clonedNode.toElement().setAttribute( ATT_LABEL, result );
	newParentNode.appendChild( clonedNode );
	
	save();
	
	site.setLabel( result );
	site.setParent( newParent );
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site << oldParent << oldName;
	emitDCOPSignal( "siteMoved(SiteInfo,QString,QString)", data );
}
//-----------------------------------------------
void SiteManagerDB::changeSite( SiteInfo site, QString oldLabel ) {
	QDomElement parent = findParent( site.parent() );
	QDomNode node =  KBearDomHelper::findNodeByAttribute( parent, TAG_SITE, ATT_LABEL, oldLabel );	
	if( node.isNull() ) // site doesn't exist
		return;

	parent.removeChild( node );
	addSite( parent, site );

	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site << oldLabel;
	emitDCOPSignal( "siteChanged(SiteInfo,QString)", data );
}
//-----------------------------------------------
SiteInfo SiteManagerDB::getSite( SiteInfo site ) {
	kdDebug()<<"SiteManagerDB::getSite IN="<<site.toString()<<endl;
	QDomNode siteNode = findSite( site );
	if( siteNode.isNull() ) {// not found
		site.setLabel( QString::null );
		site.setPort( 99 ); // Debugging!!!
		return site;
	}

	QString tmp;
	QTextStream stream( &tmp, IO_WriteOnly );
	stream << siteNode;
	site.setContent( tmp );
	QDomNode parent = siteNode.parentNode();
	if( ! parent.isNull() ) {
		kdDebug()<<"SiteManagerDB::getSite got parent"<<endl;
		QString path = getFullPath( parent.toElement() );
		site.setParent( path );
	}
	kdDebug()<<"SiteManagerDB::getSite OUT="<<site.toString()<<endl;
	return site;
}
//-----------------------------------------------
bool SiteManagerDB::addGroup( Group& group ) {
	QDomElement parent;
	if( group.parent().isNull() )
		parent = m_siteDataBase.documentElement();
	else
		parent = findParent( group.parent() );
	if( parent.isNull() ) // wasn't able to set parent node
		return false;
	addGroup( parent, group );
	return true;
}
//-----------------------------------------------
void SiteManagerDB::addGroup( QDomElement parentNode, Group& group ) {
	QDomNodeList list = parentNode.childNodes();

	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = group.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( list.item( i ).toElement().attribute(ATT_LABEL) == result )
				exist = true;
		}

	}while( exist );	

	QDomElement element = KBearDomHelper::addEmptyElement( m_siteDataBase, parentNode, TAG_GROUP );
	element.setAttribute( ATT_LABEL, result );
}
//-----------------------------------------------
void SiteManagerDB::removeGroup( Group group ) {
	QDomNode groupNode = findGroup( group );
	if( groupNode.isNull() )
		return;

	QDomNode parent = groupNode.parentNode();
	parent.removeChild( groupNode );
	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );;
	arg << group;
	emitDCOPSignal( "groupRemoved(Group)", data );
}
//-----------------------------------------------
QString SiteManagerDB::getFullPath( QDomElement e ) {
	QString pathName = QString::null;
	while( e != m_siteDataBase.documentElement() ) {
		pathName = "/" + e.attribute( ATT_LABEL ) + pathName;
		e = e.parentNode().toElement();
	}
	if( pathName.isEmpty() )
		pathName = "/" ;
	return pathName;
}
//-----------------------------------------------
void SiteManagerDB::moveGroup( Group group, QString newParent ) {
	QDomNode groupNode = findGroup( group );
	if( groupNode.isNull() )
		return;

	QDomNode oldParentNode = groupNode.parentNode();
	QDomNode newParentNode = findParent( newParent );

	if( oldParentNode == newParentNode ) // the group wasn't actually moved
		return;

	QString oldParent = getFullPath ( oldParentNode.toElement() );
	oldParentNode.removeChild( groupNode );
	QDomNode clonedNode = groupNode.cloneNode( true );
	newParentNode.appendChild( clonedNode );

	save();
	
	group.setParent( newParent );	
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group << oldParent;
	emitDCOPSignal( "groupMoved(Group,QString)", data );
}
//-----------------------------------------------
void SiteManagerDB::saveGroup( Group group ) {
	QDomNode node;
	if( group.label().isEmpty() || group.label().isNull() )  // we don't want an empty label
		group.setLabel( i18n( "No Name" ) );

	if( ! addGroup( group ) )
		return;

	save();
	
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group;
	emitDCOPSignal( "newGroup(Group)", data );
}
//-----------------------------------------------
void SiteManagerDB::changeGroup( Group group, QString oldLabel ) {
	QString result;
	int num = 1;
	QString addStr = QString::null;
	bool exist;
	QDomElement parentNode = findParent( group.parent() );
	QDomNodeList list = parentNode.childNodes();
	do {
		exist = false;
		addStr = ( ( num>1 ) ? (" ("+QString::number(num)+")" ): QString::null ) ;	
		result = group.label() + addStr;	
		++num;
		for( unsigned int i = 0; i < list.count(); i++ ) {
			if( list.item( i ).toElement().attribute(ATT_LABEL) == result )
				exist = true;
		}

	}while( exist );	

	group.setLabel( oldLabel );
	QDomNode groupNode = findGroup( group );
	groupNode.toElement().setAttribute(ATT_LABEL, result );
	group.setLabel( result );
	
	save();

	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group << oldLabel;
	emitDCOPSignal( "groupChanged(Group,QString)", data );
}
//-----------------------------------------------
void SiteManagerDB::save(){
	save( m_siteDataBase, m_siteManagerFile );
}
//-----------------------------------------------
void SiteManagerDB::save( QDomDocument doc, const QString& fileName ){
	kdDebug()<<"save()"<<endl;
	QFile file( fileName );
	file.open( IO_WriteOnly );
	QTextStream fileStream( &file );
	doc.save( fileStream, 10 );
	fileStream<<flush;
	file.close();
}
//-----------------------------------------------
void SiteManagerDB::makeValidDomTree(){
	QDomDocument tmpDoc; // We build a new document
	//first we need a <sites/> element as root
	QDomElement root;
	QDomElement newRoot;
	if( m_siteDataBase.documentElement().isNull() ) // no root
		newRoot = tmpDoc.createElement( TAG_SITES );
	else {
		QDomElement root = m_siteDataBase.documentElement();
		if( root.tagName() != TAG_SITES ) { // The root isn't a sites tag, sorry ;)
			QString fName = m_siteManagerFile+".old";
			kdError()<<QString("The file: %1 isn't valid. It vill be saved as %2 and a new empty file will be created.").
									arg( "sitemanager.xml" ).arg( fName )<<endl;
			save( m_siteDataBase, fName );	
			newRoot = tmpDoc.createElement( TAG_SITES );
		}
		else
			newRoot = root.cloneNode( true ).toElement();
	}
	newRoot.setAttribute( ATT_ENCODING, m_encoding );	
	newRoot.setAttribute( ATT_VERSION, IDS_VERSION );
	tmpDoc.setContent( QString("<?xml version=\"1.0\" encoding=\"%1\"?>").arg(m_encoding) );
	tmpDoc.appendChild( newRoot );
	m_siteDataBase.setContent( tmpDoc.toString() );
	// we localize the Personal entry
	QDomNodeList nodeList = m_siteDataBase.elementsByTagName( TAG_GROUP );
	for( unsigned int i = 0; i < nodeList.count(); i++ ) {
		QString lbl = nodeList.item( i ).toElement().attribute( ATT_LABEL );
		if( lbl == "Personal" )
			nodeList.item( i ).toElement().setAttribute( ATT_LABEL, i18n("Personal") );
		if( lbl == "Imported Bookmarks" )
			nodeList.item( i ).toElement().setAttribute( ATT_LABEL, i18n("Imported Bookmarks") );
	}
			
}
//-----------------------------------------------
QString SiteManagerDB::encoding() {
	if(m_siteDataBase.documentElement().isElement() ) {
		m_encoding = m_siteDataBase.documentElement().toElement().attribute(ATT_ENCODING);
	}
	else
		m_encoding = QString::null;

	return m_encoding;
}
//-----------------------------------------------
void SiteManagerDB::setEncoding( QString encoding ){
	m_encoding = encoding;
	makeValidDomTree();
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << encoding;
	emitDCOPSignal( "newEncoding", data );
}
//-----------------------------------------------
void SiteManagerDB::importDomDocument( QString domDocument ) {
	QDomElement importElement;
	QDomDocument tmpDoc;
	tmpDoc.setContent( domDocument );
	QDomElement newElement = tmpDoc.documentElement();
	QDomNodeList nodeList = m_siteDataBase.documentElement().childNodes();
	int nodeCount = 0;
	for( unsigned int i = 0; i < nodeList.count(); i++ ) {
		if( nodeList.item( i ).toElement().attribute(ATT_LABEL) == i18n("Imported Bookmarks") ) {
			importElement = nodeList.item( i ).toElement();
			QDomNodeList nodeList2 = importElement.childNodes();
			for( unsigned int j = 0; j < nodeList2.count(); j++ ) {
				QString tmp = newElement.attribute( ATT_LABEL );
				if( nodeList2.item( j ).toElement().attribute(ATT_LABEL).left( tmp.length() ) == tmp ) {
					++nodeCount;					
				}
			}
			if( nodeCount > 0 )
				newElement.setAttribute(ATT_LABEL, newElement.attribute( ATT_LABEL )+ QString("(%1)").arg(nodeCount+1) );
		}
	}	
	if( importElement.isNull() ) {
		QDomElement rootElement = m_siteDataBase.documentElement();
		importElement = KBearDomHelper::addEmptyElement( tmpDoc, rootElement, TAG_GROUP );
		importElement.setAttribute( ATT_LABEL, i18n("Imported Bookmarks") );
	}

    QDomElement dbNewElement = KBearDomHelper::addEmptyElement( m_siteDataBase, importElement, newElement.tagName() );
	dbNewElement.setAttribute( ATT_LABEL, newElement.attribute( ATT_LABEL ) );
	
	parseImportTree( newElement, dbNewElement );
	
	save();
	
	QCString signal( "updateDatabase(QString)" );
	QCString e;
	QDataStream stream(e, IO_WriteOnly );
	stream << m_siteDataBase.toString();
	emitDCOPSignal( signal, e );
}
//-----------------------------------------------
void SiteManagerDB::parseImportTree( QDomElement parentElement, QDomElement dbParentElement ) {
	QDomNode node = parentElement.firstChild();
	while( ! node.isNull() ) {
		QString name;
		int sleep, count;
		if( node.toElement().tagName() == TAG_GROUP ) {
			name = node.toElement().attribute( ATT_LABEL );
			QDomElement newElement = KBearDomHelper::addEmptyElement( m_siteDataBase, dbParentElement, TAG_GROUP );
			newElement.setAttribute( ATT_LABEL, name );
			// recursive build of the tree
			parseImportTree( node.toElement(), newElement );
		}
		else if( node.toElement().tagName()  == TAG_SITE ) {
			name = node.toElement().attribute( ATT_LABEL );
			QDomElement newElement = KBearDomHelper::addEmptyElement( m_siteDataBase, dbParentElement, TAG_SITE );
			newElement.setAttribute( ATT_LABEL, name );
			// recursive build of the tree
			parseImportTree( node.toElement(), newElement );
		}
		else if( node.toElement().tagName() == TAG_AUTO_RECONNECT ) {
			sleep = node.toElement().attribute( ATT_SLEEP ).toInt();
			count = node.toElement().attribute( ATT_COUNT ).toInt();
			QDomElement newElement = KBearDomHelper::addEmptyElement( m_siteDataBase, dbParentElement, TAG_AUTO_RECONNECT );
			newElement.setAttribute( ATT_SLEEP, sleep );
			newElement.setAttribute( ATT_COUNT, count );
			// recursive build of the tree
			parseImportTree( node.toElement(), newElement );
		} else if( node.isElement() ) {
			QDomElement newElement = KBearDomHelper::addEmptyElement( m_siteDataBase, dbParentElement, node.toElement().tagName() );
			// recursive build of the tree
			parseImportTree( node.toElement(), newElement );
		}
		else if( node.isText() ) {
			QDomText text = m_siteDataBase.createTextNode( node.toText().data() );
			dbParentElement.appendChild( text );
		}
		node = node.nextSibling();
	}
}
//-----------------------------------------------
/*
void SiteManagerDB::showSystemTrayIcon(bool show) {
	kdDebug()<<"SiteManagerDB::showSystemTrayIcon="<<show<<endl;
	if( show )
		m_dockWindow->show();
	else
		m_dockWindow->hide();
	QCString signal( "showSystemTray(bool)" );
	QByteArray data;
	QDataStream stream( data, IO_WriteOnly );
	stream << show;
	emitDCOPSignal( signal, data );
}
*/
//-----------------------------------------------
void SiteManagerDB::setPlugInKonq(bool plug ) {
	kdDebug()<<"SiteManagerDB::setPlugInKonq="<<plug<<endl;
	QString copyFile = locate( "data", "kbearsitemanager/kbearsitemanagerui.rc" );
	QString tmpPath = locateLocal( "data", "konqueror/kpartplugins/kbearsitemanagerui.rc" );
	QString listViewPath = locateLocal( "data", "konqlistview/kpartplugins/kbearsitemanagerui.rc" );
	QString iconViewPath = locateLocal( "data", "konqiconview/kpartplugins/kbearsitemanagerui.rc" );
	// this is temp code
	if( KStandardDirs::exists( tmpPath ) )
		KIO::file_delete( tmpPath );
	// temp code end
	if( plug ) {
		if( ! copyFile.isNull() ) {
			if( ! KStandardDirs::exists( listViewPath ) ) 
				KIO::copy( copyFile, listViewPath, false );
			if( ! KStandardDirs::exists( iconViewPath ) ) 
				KIO::copy( copyFile, iconViewPath, false );
		}
	}
	else {
		if( KStandardDirs::exists( listViewPath ) )
			KIO::file_delete( listViewPath );
		if( KStandardDirs::exists( iconViewPath ) )
			KIO::file_delete( iconViewPath );
	}

	QCString signal( "plugInKonq(bool)" );
	QByteArray data;
	QDataStream stream( data, IO_WriteOnly );
	stream << plug;
	emitDCOPSignal( signal, data );
}
