/***************************************************************************
                          sitemanagerdbiface.h  -  description
                             -------------------
    begin                : lr mar 16 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SITEMANAGERDBIFACE_H
#define SITEMANAGERDBIFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <dcopobject.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"
#include "group.h"

/**
  *@author Bjrn Sahlstrm
  */
using namespace KBear;
class SiteManagerDBIface :  virtual public DCOPObject {
	K_DCOP
k_dcop:
	/**
	* The sitemanager plugin calls this every second..
	*/
	virtual bool ping() = 0;
	/**
	* Each instance using the database has to register.
	* The app exit when last referer has unregistered.
	* @see #unregReferer
	*/
	virtual ASYNC regReferer() = 0;
	/**
	* Each instance using the database must unregister when it has no more use of the database.
	* The app exit when last referer has unregistered.
	* @see #regReferer
	*/
	virtual ASYNC unregReferer() = 0;
	/**
	* Call this to save a @ref Site .
	* Emits DCOP signal @ref #newSite
	* @param site @ref Site to add.
	* @see #newSite
	*/
	virtual ASYNC saveSite( SiteInfo site ) = 0;
	/**
	* Call this to change an existing @ref Site.
	* Emits DCOP signal @ref #changeSite
	* @param site @ref Site to change.
	* @param oldLabel is the old label before change.
	* @see #changeSite
	*/
	virtual ASYNC changeSite( SiteInfo site, QString oldLabel ) = 0;
	/**
	* Call this to remove a @ref Site .
	* Emits DCOP signal @ref #siteRemoved
	* @param site is the @ref Site to remove.
	* @see #siteRemoved
	*/
	virtual ASYNC removeSite( SiteInfo site ) = 0;
	/**
	* Call this to move a @ref Site within the site tree.
	* Emits DCOP signal @ref #siteMoved
	* @param site is the @ref Site to move.
	* @param newParent is the new parent for the @ref Site to move.
	* @see #siteMoved
	*/
	virtual ASYNC moveSite( SiteInfo site, QString newParent ) = 0;
	/**
	* @param site should containn the parent and the label for the site to retrieve.
	* @return a @ref Site matching the label and the parent
	*/
	virtual SiteInfo getSite( SiteInfo site ) = 0;
	/**
	* Call this to save a new @ref Group.
	* Emits DCOP signal @ref #newGroup
	* @param group @ref Group to add.
	* @see #newGroup
	*/
	virtual ASYNC saveGroup( Group group ) = 0;
	/**
	* Call this to change an existing @ref Group.
	* Emits DCOP signal @ref #changeGroup
	* @param group @ref Group to change.
	* @param oldLabel is the old label before change.
	* @see #changeGroup
	*/
	virtual ASYNC changeGroup( Group group, QString oldLabel ) = 0;
	/**
	* Call this to remove a @ref Group.
	* Emits DCOP signal @ref #groupRemoved
	* @param group is @ref Group to remove.
	* @see #groupRemoved
	*/
	virtual ASYNC removeGroup( Group group ) = 0;
	/**
	* Call this to move a @ref Group within the site tree.
	* Emits DCOP signal @ref #groupMoved
	* @param group is @ref Group to move.
	* @param newParent is the new parent for the @ref Group to move.
	* @see #groupMoved
	*/
	virtual ASYNC moveGroup( Group group, QString newParent ) = 0;
	/**	
	* Call this to receive the entire database Dom Document as a @ref QString.
	*/
	virtual QString getSiteDataBase() = 0;
	/**	
	* Call this to retreive the encoding of the database.
	* @return a @ref QString containing the encoding like: 'iso 8859-1'
	* @see #setEncoding
	*/
	virtual QString encoding() = 0;
	/**	
	* Call this to set the encoding of the database.
	* emitts the signal @ref #newEncoding
	* @param encoding should contain the new encoding like: 'iso 8859-1'
	* @see #encoding
	* @see #newEncoding
	*/
	virtual ASYNC setEncoding( QString encoding ) = 0;
	/**	
	* Call this to import a @ref QDomDocument.
	* The imported groups/sites will be placed in a @ref Group called "Imported Bookmarks".
	*/
	virtual ASYNC importDomDocument( QString domDocument ) = 0;
	/** */
//	virtual ASYNC showSystemTrayIcon(bool) = 0;
	/** */
	virtual ASYNC setPlugInKonq(bool) = 0;

k_dcop_signals:
	/**
	* Emitted whenever a new @ref Site is added to database.
	*/
	void initialize();
	/**
	* Emitted whenever a new @ref Site is added to database.
	*/
	void newSite( SiteInfo site );
	/**
	* Emitted whenever a @ref Site is changed in database.
	*/
	void siteChanged( SiteInfo site, QString oldName );
	/**
	* Emitted whenever a @ref Site is removed from database.
	*/
	void siteRemoved( SiteInfo site );
	/**
	* Emitted whenever a @ref Site is moved within site tree.
	*/
	void siteMoved( SiteInfo site, QString oldParent, QString oldName );
	/**
	* Emitted whenever a new @ref Group is added to database.
	*/
	void newGroup( Group group );
	/**
	* Emitted whenever a @ref Group is changed in database.
	*/
	void groupChanged( Group group, QString oldName );
	/**
	* Emitted whenever a @ref Group is removed from database.
	*/
	void groupRemoved( Group group );
	/**
	* Emitted whenever a @ref Group is moved within site tree.
	*/
	void groupMoved( Group site, QString oldParent );
	/**
	* Emitted whenever the encoding is cahnged.
	* @param encoding is the new encoding
	* @see #setEncoding
	*/
	void newEncoding( QString encoding );
	/**
	* Emitted whenever the whole site tree needs to be updated.
	* @param domTree is the @ref QString representation of the new @ref QDomDocument.
	*/
	void updateDatabase( QString domTree );
	/**
	* Emitted to import old version of KBear sitemanager.
	* @param fileName is the full path to the file to import.
	*/
	void importOldSitemanager(QString fileName);
	/** */
	void showSystemTray(bool);
	/** */
	void plugInKonq(bool);
};

#endif
