# Temporary macros. To remove later
%define _prefix         /opt/kde3/
%define _exec-prefix    /opt/kde3/
%define _bindir         /opt/kde3/bin/
%define _sbindir        /opt/kde3/sbin/
%define _sysconfdir     /opt/kde3/etc/
%define _datadir        /opt/kde3/share/
%define _includedir     /opt/kde3/include/
%define _libdir         /opt/kde3/lib/
%define _libexecdir     /opt/kde3/lib/
%define _localstatedir  /opt/kde3/var/lib/
%define _sharedstatedir /opt/kde3/com/
%define _mandir         /opt/kde3/share/man/
%define _infodir        /opt/kde3/share/info/
%define _docdir         /opt/kde3/share/doc/
%define _menudir	/usr/lib/menu/


# Define macro used to control build options for each LMDK distributions
%define buildfor $(awk '{print $4}' /etc/mandrake-release)
%{expand:%%define buildfor8_0 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 8.0 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor8_1 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 8.1 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor8_2 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 8.2 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor9_0 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 9.0 ]; then echo 1; else echo 0; fi)}

# Define if we build a stable release or not
#                              0 = stable
#                              1 = unstable
%define unstable 0

%if %buildfor8_0
%define mdk_version 8.0

BuildRequires:  XFree86-devel XFree86-libs XFree86-static-libs
BuildRequires:  autoconf automake kdelibs3-devel
BuildRequires:  libqt3 libqt3-devel
%endif

%if %buildfor8_1
%define mdk_version 8.1

BuildRequires:  XFree86-devel XFree86-libs XFree86-static-libs
BuildRequires:  autoconf automake kdelibs3-devel
BuildRequires:  libqt3 libqt3-devel
%endif

%if %buildfor8_2
%define mdk_version 8.2

BuildRequires:  XFree86-devel XFree86-libs XFree86-static-libs
BuildRequires:  autoconf automake kdelibs3-devel
BuildRequires:  libqt3 libqt3-devel
%endif

%if %buildfor9_0
%define mdk_version 9.0

BuildRequires:  XFree86-devel XFree86-libs XFree86-static-libs
BuildRequires:  autoconf automake kdelibs3-devel
BuildRequires:  libqt3 libqt3-devel
%endif

Summary: K Desktop Environment - Graphical FTP Client
Name:      kbear
Version:   2.1
Distribution: Mandrake
Release:   1mdk.%mdk_version
Vendor:    Bjrn Sahlstrm <kbjorn@users.sourceforge.net>
Url:       http://kbear.sourceforge.net

Packager:  Bjrn Sahlstrm <kbjorn@users.sourceforge.net>
Group:     Networking/File transfer
BuildRoot: 	%_tmppath/%name-%version-%release-root
Source:    %name-%version.src.tar.bz2
License: 	GPL

%description
KBear is a graphical ftp client for KDE with ability to concurrent to multiple hosts.




%prep
%setup
%if %unstable
CFLAGS="-O2 -g3 -march=i586" CXXFLAGS="-O2 -g3 -pedantic -march=i586" \
%else
CFLAGS="-O2 -march=i586" CXXFLAGS="-O2 -pedantic -march=i586" \
%endif
        ./configure --prefix=%_prefix \
			--build=i586-mandrake-linux-gnu \
			--host=i586-mandrake-linux-gnu \
			--enable-shared \
			--disable-static \
%if %unstable
			--enable-debug=full \
%else
			--disable-debug \
%endif
			--enable-final \

%build
export QTDIR=/usr/lib/qt3
export KDEDIR=%_prefix

export LIBRARY_PATH=$QTDIR/lib:$KDEDIR/lib:$LIBRARY_PATH
export LD_LIBRARY_PATH=$QTDIR/lib:$KDEDIR/lib:$LD_LIBRARY_PATH
export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
  numprocs=1
fi

make -j$numprocs

%install

rm -fr %buildroot

export PATH=%_bindir:$PATH

make install DESTDIR=%buildroot

# Create LMDK menus
install -d %buildroot/%_menudir

kdedesktop2mdkmenu.pl kbear Networking/File\ transfer %buildroot/%_datadir/applnk/Internet/kbear.desktop %buildroot/%_menudir/kbear

cd %buildroot
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.kbear
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.kbear
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.kbear

%clean
rm -rf %buildroot/*
rm -rf $RPM_BUILD_DIR/kbear
rm -rf ../file.list.kbear


%files -f ../file.list.kbear

%post
rm -f %_datadir/apps/konqueror/kpartplugins/kbearsitemanagerui.rc
rm -f %_datadir/apps/konqiconview/kpartplugins/kbearsitemanagerui.rc
rm -f %_datadir/apps/konqlistview/kpartplugins/kbearsitemanagerui.rc
rm -f %_datadir/apps/kbearsitemanager/kpartplugins/*.rc
/sbin/ldconfig
%update_menus

%postun
/sbin/ldconfig
%clean_menus


