/*********************************************************************************
* C++ Implementation: kbearchildview.cpp
* Description:
*
* Begin : tis mar 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qlayout.h>
#include <qcursor.h>
#include <qevent.h>
#include <qtextcodec.h>
#include <qpixmap.h>
#include <qtimer.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kurl.h>
#include <klibloader.h>
#include <dcopclient.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kicontheme.h>
#include <kconfig.h>
#include <kaction.h>
#include <klocale.h>
#include <kurldrag.h>
#include <kstatusbar.h>
#include <kparts/part.h>
#include <kparts/componentfactory.h>
#include <kmessagebox.h>
#include <kxmlguiclient.h>

#include <kdebug.h>
//////////////////////////////////////////////////////
// System specific includes
//#include <X11/Xlib.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearchildview.h"
#include "kbearmainwiniface.h"
#include "kbearfilesyspartiface.h"
#include "kbearcore.h"
#include "kbeartoplevel.h"
#include "kbearpartmanager.h"
#include "kbearpartiface.h"
#include "api.h"
#include "resource.h"

#include "kbearchildview.moc"

using namespace KBear;
//-----------------------------------------------
KBearChildView::KBearChildView( QWidget *parent, const SiteInfo& c )
	:	QWidget( parent, c.label().latin1() ),
		DCOPObject( c.label().latin1() ),
		m_siteInfo( c ), m_part( 0L )
{
	new QVBoxLayout( this );
	if( ! kapp->dcopClient()->isRegistered() ) {
		kapp->dcopClient()->attach();
		kapp->dcopClient()->registerAs( PACKAGE );
	}
	setObjId( c.label().latin1() );
	setFocusPolicy( QWidget::WheelFocus );
	setIcon( KGlobal::iconLoader()->loadIcon( "ftp", KIcon::Small) );
	QTimer::singleShot( 0, this, SLOT( slotInit() ) );
}
//-----------------------------------------------
KBearChildView::~KBearChildView(){
	if( m_part ) {
		m_part->stop();
		delete m_part;
	}
}
//-----------------------------------------------
/*
void KBearChildView::focusInEvent( QFocusEvent* e ) {
	QWidget::focusInEvent( e );
	if( m_part ) {
	//	if( e && (e->reason() != QFocusEvent::Popup) ) {
			API::getInstance()->partManager()->setActivePart( m_part->activePart() );
			QString tmp = m_part->currentURL().prettyURL();
			m_part->slotSetWindowCaption( m_part->toUnicode( tmp ) );
	//	}
	}
}
*/
//-----------------------------------------------
void KBearChildView::slotInit() {
	KParts::DockMainWindow* parent = API::getInstance()->mainWindow()->mainWindow();
	if( m_siteInfo.isLocal() ) {
		m_part = KParts::ComponentFactory::createPartInstanceFromLibrary<KBearFileSysPartInterface>
									("libkbearlocalfilesyspart", this, "KBearWidget", API::getInstance(), "kbearlocalfilesyspart" );
	}

	else {
		m_part = KParts::ComponentFactory::createPartInstanceFromLibrary<KBearFileSysPartInterface>
									("libkbearremotefilesyspart", this, "KBearWidget", API::getInstance(), "kbearremotefilesyspart" );
	}
	kdDebug()<<k_funcinfo<<" received part="<<m_part<<endl;

	if( m_part ) {
		layout()->add( m_part->widget() );
		setFocusProxy( m_part->widget() );
//		setupConnections();
		connect( parent->guiFactory(), SIGNAL( clientAdded( KXMLGUIClient* ) ), this, SLOT( slotClientAdded( KXMLGUIClient* ) ));
		connect( m_part, SIGNAL( setStatusBarText( const QString& ) ), parent->statusBar(), SLOT( message( const QString& ) ) );
		connect( m_part, SIGNAL( setWindowCaption( const QString& ) ), parent, SLOT( setCaption( const QString& ) ) );
		connect( m_part, SIGNAL( selectionChanged() ), this, SIGNAL( selectionChanged() ) );
		connect( m_part, SIGNAL( closeMe() ), this, SIGNAL( closeMe() ) );
		API::getInstance()->partManager()->addPart( m_part );
	}
	else {
		KMessageBox::sorry( this, i18n("Unable to find a KBear filesyspart, KBear won't work properly without it so the application will exit !\n"
						"Please make sure that KBear is installed in your KDE directory, otherwise you have to add KBear's installation "
						"path to the environment variable KDEDIRS and run kbuildsycoca. Restart KBear afterwards.\n"
						"Example for BASH users:\nexport KDEDIRS=/path/to/kbear:$KDEDIRS && kbuildsycoca\n"),
						i18n("Unable to find a  filesys part") );
		parent->close();
	}
}
//-----------------------------------------------
void KBearChildView::slotClientAdded( KXMLGUIClient* client ) {
	KBearFileSysPartInterface* part =  dynamic_cast<KBearFileSysPartInterface*>( client );
	kdDebug()<<k_funcinfo<<" part="<<part<<endl;
	if( part && part == m_part ) {
		disconnect( API::getInstance()->mainWindow()->mainWindow()->guiFactory(), SIGNAL( clientAdded( KXMLGUIClient* ) ), this, SLOT( slotClientAdded( KXMLGUIClient* ) ));
		m_part->init(m_siteInfo);
		m_part->openConnection( m_siteInfo );
		readProperties( kapp->config(), "View Settings" );
	}
}
//-----------------------------------------------
void KBearChildView::setPath( QString path ) {
	if( m_part )
		m_part->setPath( path );
}
//-----------------------------------------------
const KURL::List KBearChildView::selectedURLs() const {
	if( m_part )
		return m_part->selectedURLs();

		return KURL::List();
}
//-----------------------------------------------
const KFileItemList* KBearChildView::selectedItems() const {
	if( m_part )
		return m_part->selectedItems();

		return 0L;
}
//-----------------------------------------------
void KBearChildView::reload() {
	if( m_part )
		m_part->reload();
}
//-----------------------------------------------
void KBearChildView::home() {
	if( m_part )
		m_part->home();
}
//-----------------------------------------------
void KBearChildView::cdUp() {
	if( m_part )
		m_part->cdUp();
}
//-----------------------------------------------
void KBearChildView::back() {
	if( m_part )
		m_part->back();
}
//-----------------------------------------------
void KBearChildView::forward() {
	if( m_part )
		m_part->forward();
}
//-----------------------------------------------
void KBearChildView::stop() {
	if( m_part )
		m_part->stop();
}
//-----------------------------------------------
QString KBearChildView::currentURL() const {
	return m_part ? m_part->currentURL().prettyURL() : QString::null;
}
//-----------------------------------------------
void KBearChildView::readProperties( KConfig* config, const QString& group ) {
	if( m_part )
		m_part->readProperties( config, group );
}
//-----------------------------------------------
void KBearChildView::saveProperties( KConfig* config, const QString& group ) {
	if( m_part )
		m_part->saveProperties( config, group );
}
//-----------------------------------------------
QPopupMenu* KBearChildView::popupMenu() {
	return m_part ? m_part->popupMenu() : 0L;
}
//-----------------------------------------------
bool KBearChildView::isLocal() const {
	return m_part->isLocal();
}
//-----------------------------------------------
