/*************************************************************************

                          kbearmainwindow.h  -  description
                             -------------------
    begin                : mn  jan 13 2003
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KBEAR_H
#define KBEAR_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrlist.h>
#include <qdir.h>
#include <qmap.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kaction.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kmdimainfrm.h"
#include "kmdichildview.h"
#include "kbearchildview.h"
#include "kbearmainwiniface.h"
#include "kbearmainwindowshared.h"
#include "kbeartoplevel.h"
#include "miscsettingswidget.h"
#include "core.h"
#include "api.h"
#include "siteinfo.h"

using namespace KBear;

class KBearChildView;
class KToolBar;
class KWizard;

/**
	* This Class represent main window of the KBear application. 
	* It provides a menubar, a toolbar and a statusbar.
	* It's also the manager for all child windows.
	*
	* @short This Class represent main window of the KBear application
	* @see KMdiMainFrm
	* @author Bjrn Sahlstrm <kbjorn@users.sourceforge.net>
*/

class KBearMainWindow :  public KMdiMainFrm, public KBearMainWindowInterface {
	Q_OBJECT
	friend class KBearMainWindowShared;
public:
	/** Default Constructor */
	KBearMainWindow();
	/** Destructor */
	~KBearMainWindow();
	/** */
	virtual void raiseMainWindow();
	/** @return reference to the current @ref KBearMdiChildView */
	virtual DCOPRef currentChildView();
	/** */
	virtual void embedOutputPluginView( QWidget* view, const QString& title, const QString& toolTip );
	/** */
	virtual void removeOutputPluginView( QWidget *view );
	/** */
	virtual void raiseView(QWidget* view);
	/** */
	virtual KParts::DockMainWindow *mainWindow();
	/** */
	virtual void setLocalPath( const QString& );
	/** */
	virtual void realClose();
	/**  */
	virtual bool queryClose();
	/** */
	virtual void closeCurrentView();
	/** */
	virtual void closeAll();
	/** */
	virtual const KBearChildViewIface* getCurrentView();
	/** */
	virtual const KBearChildViewIface* getLocalView();
	/**  */
	void init();
	/** */
	virtual KBearCore* core()
				{ return API::getInstance()->core(); }
	/** */
	virtual KBearAPI* api()
				{ return API::getInstance(); }
	/** */
	virtual KBearConfigWidgetIface* miscSettingsWidget()
				{ return MiscSettingsWidget::getInstance(); }
	/**
	* Reimplemented from @ref KMdiMainFrm.
	* Catches certain Qt events and processes it here.
	* Currently, here this catches only the @ref KMdiViewCloseEvent (a QextMDI user event) which is sent
	* from itself in @ref childWindowCloseRequest() right after a @ref KMdiChildView::closeEvent() .
	* The reason for this event to itself is simple: It just wants to break the function call stack.
	* It breaks the processing if the @ref KMdiChildView is the LocalFileSystem view
	* with calling @ref slotOptionsShowViewLocal() because we don't want that to close only hide.
	*/
	virtual bool event(QEvent* e);
	/**
	* Returns a popup menu with only a title "Window". You can fill it with own operations entries
	* on the MDI view. This popup menu is inserted as last menu item in @ref taskBarPopup() .
	*/
	virtual QPopupMenu * windowPopup(KMdiChildView *pWnd,bool bIncludeTaskbarPopup = TRUE);
	/** */
	virtual void showViewLocal();
	/** */
	virtual void applyUISettings();
	/** */
	virtual void readViewSettings();
	/**
	* This method is called when it is time for the app to save its
	* properties for session management purposes.
	*/
	virtual void saveProperties( KConfig* );
	/**
	* This method is called when this app is restored.  The KConfig
	* object points to the session management config file that was saved
	* with @ref saveProperties
	*/
	virtual void readProperties( KConfig* );
	/** */
	virtual QPtrList<KBearChildViewIface> childViews();
signals:
	void localViewGotFocus( bool );
public slots:
	/** */
	virtual void addWindow( KMdiChildView* pView, int flags = KMdi::StandardAdd);
	/** */
	virtual void closeWindow( KMdiChildView *pWnd, bool layoutTaskBar = true);
	/**  Update of the window menu contents. */
	virtual void fillWindowMenu();
	/**
	* Switches the @ref KMdiTaskBar on and off.
	*/
	virtual void slot_toggleTaskBar();
	/** Docks all view windows (Windows-like) */
	virtual void switchToChildframeMode();
	/**
	* Docks all view windows (Unix-like)
	*/
	virtual void switchToToplevelMode();
   /**
   * Docks all view windows (Windows-like)
   */
   virtual void switchToTabPageMode();
	/** Cascades the windows without resizing them.*/
	virtual void cascadeWindows();
	/** Cascades the windows resizing them to the maximum available size. */
	virtual void cascadeMaximized();
	/** Maximizes only in vertical direction. */
	virtual void expandVertical();
	/** Maximizes only in horizontal direction.*/
	virtual void expandHorizontal();
	/** Tile Pragma */
	virtual void tilePragma();
	/** Tile Anodine */
	virtual void tileAnodine();
	/** Tile Vertically	*/
	virtual void tileVertically();
protected slots:
	/** */
	void createGUI( KParts::Part* part );
private slots:
	void slotClose();
	void slotCloseChildView();
	void slotChildViewGotFocus( KMdiChildView* );
private: // Private methods
	void setChildFrameMode( unsigned int mode );
	void initViewLocal();
	void setupActions();
	void setupToolTips();
	KBearChildView* findMdiChildViewByName( const QString& name );
	virtual KBearChildViewIface* createClient( const SiteInfo& info, const QString& whatsThis );
	void saveTopChildPositions(KConfig *);
	void readTopChildPositionFromIndex(unsigned int);
	void readAllTopChildPositions();
private: // Private attributes
	KBearChildView* m_viewLocal;
	KMdiChildView* m_childViewLocal;
	QString m_viewLocalCaption;
	KActionMenu* m_dockUndockMenu;
	KActionMenu* m_mdiModeMenu;
	KActionMenu* m_tileMenu;
	KToggleAction* m_toggleTaskBar;
	QPtrList<KAction> m_windowListActions;
	QPtrList<KAction> m_dockUndockActions;
	bool m_isClosing;
	KBearMainWindowShared* m_shared;
	QMap<KBearChildView*,KMdiChildView*> m_widgetMap;    //!< Key: KBearChildView* --> Data:KMdiChildView*.\n
	QMap<KMdiChildView*,KBearChildView*> m_childViewMap; //!< Key: KMdiChildView* --> Data:KBearChildView*.\n
	bool m_autoChildFrameMode;
	unsigned int m_childFrameMode;
	bool m_rememberTopLevelChildPos;
};
#endif // KBEAR_H
 
