/*********************************************************************************
* C++ Implementation: kbearmainwindowshared.h
* Description:
*
* Begin : mn mar 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


#ifndef KBEARMAINWINDOWSHARED_H
#define KBEARMAINWINDOWSHARED_H


//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/dockmainwindow.h>
#include <kdockwidget.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files


class KBearOutputToolBar;
class KWizard;

/**
 * This class holds all shared attributes for the two GUI types
 * Bjrn Sahlstrm
 **/
class KBearMainWindowShared : public QObject {
	Q_OBJECT
public:
	/** */
	KBearMainWindowShared( KParts::DockMainWindow* parent );
	/** */
	~KBearMainWindowShared();
	/** */
	void createOutputToolbar( KDockWidget* dock );
	/** */
	KBearOutputToolBar* outputToolBar();
	/** */
	void embedOutputPluginView( QWidget* view, const QString& title, const QString& toolTip );
	/** */
	void removeOutputPluginView( QWidget *view );
	/** */
	void init();
	/**
	* This method is called when it is time for the app to save its
	* properties for session management purposes.
	*/
	void saveProperties( KConfig* );
	/**
	* This method is called when this app is restored.  The KConfig
	* object points to the session management config file that was saved
	* with @ref saveProperties
	*/
	void readProperties( KConfig* );
private slots:
	void slotSetBinaryMode();
	void slotSetAsciiMode();
	void slotSetAutoMode();
	void slotOptionsSettings();
	void slotOptionsShowViewLocal();
	void slotOptionsShowMenubar();
	void slotOptionsShowStatusbar();
	void slotOptionsSaveOptions();
	void slotOptionsConfigureToolbars();
	void slotNewToolbarConfig();
	void slotOptionsConfigureKeys();
	void slotConfigWidget( KWizard* wiz );
	void slotQuickConnect();
	void slotDisconnect();
	void slotQuit();
	void slotApplyUISettings();
	void slotApplyMiscSettings();
	void slotOptionsShowChildInfoBar();
	void slotOptionsShowChildStatusBar();
	void slotOptionsShowChildPathToolBar();
	void slotOptionsShowChildToolBar();
	void closeActiveView();
	void closeAllViews();
	void slotSetupTransferModeMenu();
	void slotSetupTransferModeMenu( unsigned int mode );
	void slotShowFullScreen();
private:
	void setupActions();
	void setupToolTips();
private:
	class KBearMainWindowSharedPrivate;
	KBearMainWindowSharedPrivate* d;
};

#endif
