/*********************************************************************************
* C++ Implementation: kbearoutputframe.cpp
* Description:
*                              
* Begin : mn jan 20 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/
//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpixmap.h>
#include <qlayout.h>
#include <qwidgetstack.h>
#include <qtoolbutton.h>
#include <qframe.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kconfig.h>
#include <kglobalsettings.h>
#include <kparts/partmanager.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearoutputframe.h"
#include "kbearmainwindow.h"
#include "api.h"

#include "kbearoutputframe.moc"

using namespace KBear;
/////////////////////////////////////////////////////////////
// class KBearOutputFrameHeader
/////////////////////////////////////////////////////////////
KBearOutputFrameHeader::KBearOutputFrameHeader( KBearOutputFrame* parent )
  : KDockWidgetAbstractHeader( parent, "KDockWidgetAbstractHeader" )
{
	setFrameStyle( QFrame::Box | QFrame::Plain );
	QVBoxLayout* vbox = new QVBoxLayout( this );
	vbox->setMargin( 2 );
	QFrame* f = new QFrame( this );
	f->setBackgroundColor( KGlobalSettings::activeTitleColor() );
	vbox->addWidget( f );

  QHBoxLayout *hbox = new QHBoxLayout( f );
	m_title = new QLabel( f );
	m_title->setPaletteBackgroundColor( KGlobalSettings::activeTitleColor() );
	m_title->setPaletteForegroundColor( KGlobalSettings::activeTextColor() );
	m_title->setAlignment(Qt::AlignCenter | Qt::ShowPrefix);
	hbox->addWidget( m_title, 1 );
	m_closeButton = new QToolButton( QToolButton::DownArrow, f );
	m_closeButton->setFixedSize( 12, 12 );
	QPalette pal = m_closeButton->palette();
	QColorGroup cg = pal.active();
	cg.setColor(QColorGroup::Background, KGlobalSettings::activeTitleColor() );
	pal.setActive( cg ) ;
	cg = pal.inactive();
	cg.setColor( QColorGroup::Background, KGlobalSettings::activeTitleColor() );
	pal.setInactive( cg ) ;
	cg = pal.disabled();
	cg.setColor( QColorGroup::Background, KGlobalSettings::activeTitleColor() );
	pal.setDisabled( cg );
	m_closeButton->setPalette( pal );

	hbox->addWidget( m_closeButton );

	connect( m_closeButton, SIGNAL(clicked() ), SIGNAL( closeButtonClicked() ) );

	hbox->addSpacing( 4 );
	vbox->activate();
	setFixedHeight( vbox->minimumSize().height() );
	show();
}
//-----------------------------------------------
KBearOutputFrameHeader::~KBearOutputFrameHeader() {
}
//-----------------------------------------------
/////////////////////////////////////////////////////////////
// class KBearOutputFrame
/////////////////////////////////////////////////////////////
//-----------------------------------------------
KBearOutputFrame::KBearOutputFrame( KParts::DockMainWindow* mainWin, KDockWidget* dockTarget )
	:	KDockWidget( mainWin->manager(), "KBearOutputFrame", QPixmap(), 0L )
{
	m_stack = new QWidgetStack( this );
	m_title = new KBearOutputFrameHeader( this );
	connect( m_title, SIGNAL(closeButtonClicked() ), SIGNAL( closeButtonClicked() ) );
	
	setHeader( m_title );
	setWidget( m_stack );
	manualDock( dockTarget, KDockWidget::DockBottom, 70 );
	m_stack->setMinimumHeight( 100 );
}
//-----------------------------------------------
KBearOutputFrame::~KBearOutputFrame() {
}
//-----------------------------------------------
void KBearOutputFrame::addWidget( QWidget* view, const QString& title, int  index ) {
	m_stack->addWidget( view, index );
	m_titleDict.insert( index, title );
	m_widgets.insert( index, view );
//	view->show();
	m_stack->raiseWidget( view );
	emit newVisibleWidget( index );
}
//-----------------------------------------------
int KBearOutputFrame::removeWidget( QWidget* view ) {
	if( ! view )
		return -1;
	int index = m_stack->id( view );
	if( index > -1 ) {
		kdDebug()<<"KBearOutputFrame::removeWidget="<<m_titleDict[ index ] <<endl;
		m_stack->removeWidget( view );
		m_titleDict.remove( index );
		m_widgets.remove( index );
		if( m_widgets.count() > 0 ) {
			QIntDictIterator<QWidget> it( m_widgets );
			emit newVisibleWidget( it.currentKey() );
		}
	}
	if( m_widgets.count() == 0 ) {
		API::getInstance()->mainWindow()->mainWindow()->makeDockInvisible( this );
	}
	return index;
}
//-----------------------------------------------
void KBearOutputFrame::setActiveIndex( int index ) {
	m_stack->raiseWidget( index );
	QWidget* widget = m_stack->widget( index );
	m_title->setTitle( m_titleDict[ index ] );
	if( widget )
		widget->setFocus();
}
//-----------------------------------------------
int KBearOutputFrame::getWidgetIndex( QWidget* widget ) {
	int index = -1;
	QIntDictIterator<QWidget> it( m_widgets );
    for ( ; it.current(); ++it ) {
		if( it.current() == widget ) { 
			index = it.currentKey();
			return index;
		}
	}
	return -1;
}
//-----------------------------------------------
