/*********************************************************************************
* C++ Interface: kbearquickconnectdlg.h
* Description:
*                              
* Begin : tis feb 04 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef _KBEARQUICKCONNECTDLG_H_
#define _KBEARQUICKCONNECTDLG_H_

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdialog.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"


using namespace KBear;

class KComboBox;
class KIntSpinBox;
class KLineEdit;
class KPasswordEdit;
class QCheckBox;
class QPushButton;

/**
 * 
 * @author Bjrn Sahlstrm
 **/
class KBearQuickConnectDlg : public QDialog {
		Q_OBJECT
	public:
		/** */
		KBearQuickConnectDlg(QWidget *parent, const char *name);
		/** */
		~KBearQuickConnectDlg();
	signals:
		void openSite( const SiteInfo& );
	protected slots: // Protected slots
		/** 
		* Close the quick connect dialog and emits @ref #openSite
		**/
		virtual void accept();
	private slots:
		void slotURLChanged( const QString& );
		void slotSelectedProtocol( const QString& protocol );
		void slotSetAnonymous( bool );
		void slotChanged();
	private:
		void setupGUI();
	private:
		KLineEdit* m_hostNameEdit;
		KIntSpinBox* m_portSpinBox;
		KComboBox* m_protocolComboBox;
		QCheckBox* m_anonymousCheck;
		KLineEdit* m_userNameEdit;
		KLineEdit* m_passwordEdit;
		KLineEdit* m_remoteDirEdit;
		KLineEdit* m_urlEdit;
		QCheckBox* m_saveToSiteManagerCheckBox;
		KURL m_url;
		bool m_hasKBearFTP;
};

#endif
