/***************************************************************************
                          kbeartoplevel.cpp  -  description
                             -------------------
    begin                : tis jan 14 2003
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qsize.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kconfig.h>
#include <kconfigbase.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartoplevel.h"
#include "kbearmainwindow.h"
#include "kbearclassicmainwindow.h"


using namespace KBear;
//-----------------------------------------------
KBearMainWindowInterface* KBearTopLevel::s_instance = 0L;
//-----------------------------------------------
KBearTopLevel::KBearTopLevel() {
}
//-----------------------------------------------
KBearTopLevel::~KBearTopLevel() {
}
//-----------------------------------------------
KBearMainWindowInterface* KBearTopLevel::getInstance() {
	if( ! s_instance ) {
		KConfig* config = kapp->config();
		KConfigGroupSaver cs( config, config->group() );
		config->setGroup( QString::fromLatin1("UI") );
		if( config->readEntry("GUIStyle", "KMdi") == "Classic" ) { // this is the "classic FTP style"
			KBearClassicMainWindow* mainWindow = new KBearClassicMainWindow();
			s_instance = mainWindow;
		}
		else { // this is the default GUI mode, old KBear style
			KBearMainWindow* mainWindow = new KBearMainWindow();
			s_instance = mainWindow;
		}
		config->setGroup( "General" );
		if( config->readBoolEntry( "First Run", true ) ) {
			QSize s = s_instance->mainWindow()->sizeForCentralWidgetSize( QSize( 640, 480 ) );
			s_instance->mainWindow()->setGeometry( 0, 0, s.width(), s.height() );
		}
		s_instance->init();
		kapp->setMainWidget( s_instance->mainWindow()  );
	}
	return s_instance;
}
//-----------------------------------------------
