/*********************************************************************************
* C++ Interface: connectioninterface.h
* Description:
*
* Begin : ons maj 7 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARCONNECTIONINTERFACE_H
#define KBEARCONNECTIONINTERFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qguardedptr.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include <siteinfo.h>

namespace KIO{
	class Slave;
	class Job;
	class SimpleJob;
}

namespace KBear {

	/**
	This is the base interface for all connection types.

	@author Bjrn Sahlstrm
	*/
	class ConnectionInterface : virtual public QObject {
			Q_OBJECT
		public:
			/** */
			ConnectionInterface( const SiteInfo& info );
			/** */
			ConnectionInterface();
			/** */
			virtual ~ConnectionInterface();
			/**
			* @return the @ref KIO::Slave associated with this connection
			*/
			virtual KIO::Slave* getSlave();
			/**
			* Call this to open the connection
			*/
			virtual bool openConnection();
			/**
			* Call this to close the connection
			*/
			virtual void closeConnection( bool force = false ) = 0;
			/**
			* Adds a @ref KIO::SimpleJob to this Connection
			* @param job the job to add
			*/
			virtual void addJob( KIO::SimpleJob* job );
			/**
			* Removes the job from this connection.
			* @param job the job to remove
			*/
			virtual void removeJob( KIO::SimpleJob* job );
			/**
			* @return the @ref SiteInfo associated with this Connection
			*/
			virtual SiteInfo getInfo() const;
		signals:
			/** */
			void infoMessage( int, const QString& );
			/** */
			void connected( int );
			/** */
			void notConnected( int );
			/** */
			void closed( int );
			/** */
			void error( int ID, int err, const QString& msg );
		protected slots:
			/** */
			virtual void slotConnected();
			/** */
			virtual void slotInfoMessage( const QString& );
			/** */
			virtual void slotJobResult( KIO::Job* job );
			/** */
			void slotSlaveError( int error, const QString& errMsg );
		protected:
			/** */
			virtual void setupSlave();
			/** */
			void slaveDied();
		protected:
			SiteInfo m_siteInfo;
			QPtrList< KIO::SimpleJob > m_jobList;
			QGuardedPtr<KIO::Slave> m_slave;
		private:
			void fillMetaData();
		private:
			KIO::MetaData m_metaData;
	};

};

#endif
