/*********************************************************************************
* C++ Interface: kbearapi.h
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARKBEARAPI_H
#define KBEARKBEARAPI_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

namespace KBear {

	class KBearMainWindowInterface;
	class KBearCore;
	class ConnectionManager;
	class TransferManager;
	class KBearPluginManagerInterface;
	class KBearPartManagerInterface;

/**
 * 
 * @author Bjrn Sahlstrm
 **/
	class KBearAPI : public QObject {
		Q_OBJECT
	public:
		/** */
		KBearAPI( QObject* );
		/** */
		virtual ~KBearAPI();
		/** */
		virtual KBearMainWindowInterface* mainWindow() = 0;
		/** */
		virtual KBearCore* core() = 0;
		/** */
		virtual ConnectionManager* connectionManager() = 0;
		/** */
		virtual TransferManager* transferManager() = 0;
		/** */
		virtual KBearPartManagerInterface* partManager() = 0;
		/** */
		virtual KBearPluginManagerInterface* pluginManager() = 0;
	};

};
#endif
