/***************************************************************************
                          kbearchildviewiface.h  -  description
                             -------------------
    begin                : tis jan 15 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARCHILDVIEWIFACE_H
#define KBEARCHILDVIEWIFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <dcopobject.h>
#include <kurl.h>
#include <kfileitem.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"

class KConfig;


namespace KBear {
	/**
	*@author Bjrn Sahlstrm
	*/
	class KBearChildViewIface : virtual public DCOPObject  {
		K_DCOP
	public:
		virtual ~KBearChildViewIface();
		/** */
		virtual void readProperties( KConfig* config,  const QString& group ) = 0;
		/** */
		virtual void saveProperties( KConfig* config,  const QString& group ) = 0;
		/** */
		virtual const KFileItemList* selectedItems() const = 0;
		/** */
		virtual const KURL::List selectedURLs() const = 0;
	k_dcop:
		/** */
		virtual ASYNC setPath( QString path ) = 0;
		/** */
		virtual ASYNC reload() = 0;
		/** */
		virtual ASYNC home() = 0;
		/** */
		virtual ASYNC cdUp() = 0;
		/** */
		virtual ASYNC back() = 0;
		/** */
		virtual ASYNC forward() = 0;
		/** */
		virtual ASYNC stop() = 0;
		/** */
		virtual QString currentURL() const = 0;
		/** */
		virtual SiteInfo siteInfo() const = 0;
		/** */
		virtual bool isLocal() const = 0;
	};

};

#endif
