/*********************************************************************************
* C++ Interface: kbeardirlisteriface.h
* Description:
*                              
* Begin : sn feb 16 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARDIRLISTERIFACE_H
#define KBEARDIRLISTERIFACE_H


//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kurl.h>
#include <kfileitem.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"

namespace KBear {
	/**
	* 
	* @author Bjrn Sahlstrm
	**/
	class KBearDirListerIface : public QObject {
		Q_OBJECT
	public:
		/** */
		KBearDirListerIface( QWidget* parent );
		/** */
		KBearDirListerIface( const SiteInfo& );
		/** */
		virtual ~KBearDirListerIface();
		/** */
		KURL url() const { return m_url; }
		/** */
		virtual bool isLocal() const = 0;
		/** */
		SiteInfo siteInfo() const { return m_siteInfo; }
		/** */
		void setSiteInfo( const SiteInfo& c );
		/** */
		virtual void openConnection() = 0;
		/** */
		virtual void closeConnection() {}
		/** */
		virtual void openURL( const KURL& url, bool reload = false ) = 0;
		/** */
		virtual void statURL( const KURL& url, bool statingLink = false ) = 0;
		/** */
		virtual void getMimetype( const KURL& url ) = 0;
		/** */
		virtual void setShowingDotFiles( bool ) = 0;
		/** */
		virtual void stop() = 0;
		/** */
		virtual void mkdir( const KURL& newDir ) = 0;
		/** */
		virtual void deleteFiles( const KURL::List urls, bool shred, bool showProgress ) = 0;
		/** */
		virtual void setNameFilter(const QString& filter) = 0;
		/** */
		virtual bool showingDotFiles() const = 0;
		/** */
		virtual QString lastMimeType() const { return m_lastMimeType; }
	public slots:
		/** */
		virtual void slotRename( const KURL& oldURL, const KURL& newURL ) = 0;
	signals:
		/** */
		void connected();
		/** */
		void started();
		/** */
		void finishedLoading();
		/** */
		void progress( int );
		/** */
		void speed( int );	
		/** */
		void newItems( const KFileItemList& );
		/** */
		void refreshItems( const KFileItemList& );
		/** */
		void deleteItem( KFileItem* );	
		/** */
		void openDir( const KURL& );	
		/** */
		void openFile( const KURL& );	
		/** */
		void redirection( const KURL& );
		/** */
		void redirection( const KURL&, const KURL& );
		/** */
		void clear();
		/** */
		void infoMessage( const QString&);
		/**
		* This signal is emitted when the slave died
		* @param error contains the error code
		* @param errMsg contains the error message. Note that this might be empty
		*/
		void error( int error, const QString& errMsg );
		/**
		* This signal is emitted when on job errors
		* @param job is the @ref KIO::Job where the error occured, you can retreive error info from the job
		*/
//		void error( KIO::Job* job );
	protected:
		SiteInfo m_siteInfo;
		KURL m_url;
		QString m_lastMimeType;
		class KBearDirListerIfacePrivate;
		KBearDirListerIfacePrivate* d;
	};

};
#endif
