/*********************************************************************************
* C++ Interface: kbeardomhelper.cpp
* Description:
*                              
* Begin : lr feb 01 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

#include "kbeardomhelper.h"


using namespace KBear;
//-----------------------------------------------
void KBearDomHelper::setNodeValue( QDomDocument& doc, QDomElement& parentNode, const QString& tagName, const QString& value ) {
	QDomElement tmpNode = parentNode.namedItem( tagName ).toElement();
	if( tmpNode.isNull() ) {
		addTextNode( doc, parentNode, tagName, value );
		return;
	}
	else if( tmpNode.firstChild().isNull() ) {
		QDomText text = doc.createTextNode( value );
		tmpNode.appendChild( text );
	}
	else
		tmpNode.firstChild().setNodeValue( value );
}
//-----------------------------------------------
QString KBearDomHelper::getAttribute( const QDomElement& parentNode, const QString& tagName, const QString& attr ) {
	QDomElement tmpNode = parentNode.namedItem( tagName ).toElement();
	if( tmpNode.isNull() ) 
		return QString::null;
	
	return tmpNode.toElement().attribute( attr );
}
//-----------------------------------------------
void KBearDomHelper::setAttribute( const QDomElement& parentNode, const QString& tagName, const QString& attr, const QString& value ) {
	QDomElement tmpNode = parentNode.namedItem( tagName ).toElement();
	if( tmpNode.isNull() ) 
		return ;
	
	tmpNode.toElement().setAttribute( attr, value );
}
//-----------------------------------------------
void KBearDomHelper::addTextNode( QDomDocument& doc, QDomElement& parentNode, const QString& tagName, const QString& value ) {
	QDomElement element = addEmptyElement( doc, parentNode, tagName );
	QDomText text = doc.createTextNode( value );
	element.appendChild( text );
}
//-----------------------------------------------
QDomElement KBearDomHelper::addEmptyElement( QDomDocument& doc, QDomElement& parentNode, const QString& tagName ){
	QDomElement element = doc.createElement( tagName );
	parentNode.appendChild( element );
	return element;
}
//-----------------------------------------------
void KBearDomHelper::removeEmptyElement( QDomElement& parentNode, const QString& tagName ){
	QDomElement tmpNode = parentNode.namedItem( tagName ).toElement();
	parentNode.removeChild( tmpNode );
}
//-----------------------------------------------
void KBearDomHelper::createBoolValue( QDomDocument& doc, QDomElement& parentNode, const QString& tagName, bool value ) {
	QDomElement tmpNode = parentNode.namedItem( tagName ).toElement();
	if( value && tmpNode.isNull() ) {
		addEmptyElement( doc, parentNode, tagName );
	}
	else if( ! value && ! tmpNode.isNull() ) {
		removeEmptyElement( parentNode, tagName );
	}
}
//-----------------------------------------------
QString KBearDomHelper::getNodeValue( const QDomElement& parentNode, const QString& tagName ) {
	QDomElement tmpNode = parentNode.namedItem( tagName ).toElement();
	if( tmpNode.isNull() ) 
		return QString::null;
			
	return tmpNode.text();
}
//-----------------------------------------------
QDomElement KBearDomHelper::getElement( const QDomElement& parentNode, const QString& tagName ) {
	QDomElement e = parentNode.namedItem( tagName ).toElement();
	return e;
}
//-----------------------------------------------
QDomNode KBearDomHelper::findNodeByAttribute( QDomElement& parent, const QString& tagName,
										const QString& attribute, const QString& label ) {
	QDomNodeList nodeList = parent.childNodes();
	for( unsigned int i = 0; i < nodeList.count(); i++ ) {
		if( nodeList.item( i ).toElement().tagName() == tagName && label == nodeList.item( i ).toElement().attribute( attribute ) ) {
			return nodeList.item( i );
		}
	}
	return QDomNode();
}
//-----------------------------------------------
