/*********************************************************************************
* C++ Interface: kbearpartiface.h
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARPARTINTERFACE_H
#define KBEARPARTINTERFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"

class QObject;
class QPopupMenu;

namespace KBear {
	class KBearAPI;
	class KBearMainWindowInterface;
	class KBearCore;
	
	/**
	* 
	* @author Bjrn Sahlstrm
	**/
	class KBearPartInterface {
	public:
		/** */
		KBearPartInterface( QObject* parent );
		/** */
		virtual ~KBearPartInterface();
		/**
		* Reimplement this method if you need to do initializations when @ref KXMLGUIFactory is set.
		* For example use the @ref KXMLGUIFactory::container method. This method can't be used before the factory is set.
		* Default implementation does nothing
		*/
		virtual void init() { }
		/** */
		virtual KURL currentURL() const = 0;
		/**
		* Gives a reference to the toplevel widget.
		*/
		KBearMainWindowInterface* mainWindow();
		/**
		* Gives a reference to the application core
		*/
		KBearCore* core();
		/**
		* Gives a reference to the parts popup menu if any.
		* @return 0L as default.
		*/
		virtual QPopupMenu* popupMenu() const { return 0L; }
		/**
		* Reimplement this method to indicate if your part works against a local filesystem.
		* @return if the part works against a local file system, default implementatioan always returns true.
		*/
		virtual bool isLocal() const = 0;
		/** */
		virtual void openConnection( const SiteInfo& c ) = 0;
	protected:
		KBearAPI* m_api;
	};

};
#endif
