/*********************************************************************************
* C++ Implementation: kbearplugin.cpp
* Description:
*                              
* Begin : tis jan 14 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kmainwindow.h>
#include <kstatusbar.h>
#include <kaction.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
#include <assert.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearplugin.h"
#include "kbearmainwiniface.h"
#include "kbearapi.h"
#include "kbearcore.h"

using namespace KBear;


#include "kbearplugin.moc"


//-----------------------------------------------
KBearPlugin::KBearPlugin( QObject* parent, const char* name )
	:	KParts::Plugin( parent, name )
{
/* Need to remove this assert inorder to get sitemanager to be able to plug into konqueror
	assert( parent->inherits( "KBear::KBearAPI" ) );
*/
	m_api = dynamic_cast<KBearAPI*>( parent );
	actionCollection()->setHighlightingEnabled( true );
	if( m_api ) {
		connect( actionCollection(), SIGNAL( actionStatusText(const QString &) ), mainWindow()->statusBar(), SLOT( message(const QString &) ) );
		connect( actionCollection(), SIGNAL( clearStatusText() ), mainWindow()->statusBar(), SLOT( clear() ) );
		connect( m_api->core(), SIGNAL(configWidget(KDialogBase*)), this, SLOT(slotConfigWidget(KDialogBase*)) );
		connect( m_api->core(), SIGNAL(configWidget(KWizard*)), this, SLOT(slotConfigWidget(KWizard*)) );
		connect( m_api->core(), SIGNAL( initialized() ), this, SLOT( slotInit() ) );
	}
}
//-----------------------------------------------
KBearPlugin::~KBearPlugin() {
}
//-----------------------------------------------
KBearMainWindowInterface* KBearPlugin::mainWindow() {
    return m_api?m_api->mainWindow():0L;
}
//-----------------------------------------------
KBearCore* KBearPlugin::core() {
    return m_api?m_api->core():0L;
}
//-----------------------------------------------
QString KBearPlugin::unloadWarning() const {
	return QString::null;
}
//-----------------------------------------------
