/*********************************************************************************
* C++ Interface: kbearplugin.h
* Description:
*                              
* Begin : tis jan 14 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARKBEARPLUGIN_H
#define KBEARKBEARPLUGIN_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/plugin.h>
#include <kwizard.h>
#include <kdialogbase.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files


namespace KBear {
	
	class KBearMainWindowInterface;
	class KBearCore;
	class KBearAPI;
	/**
	* 
	* @author Bjrn Sahlstrm
	**/
	class KBearPlugin : public KParts::Plugin{
		Q_OBJECT
	public:
		/** */
		KBearPlugin( QObject* parent, const char* name );
		/** */
		virtual ~KBearPlugin();
		/**
		* Reimplement this if you want to show the user a warning if user unloads the plugin.
		* @return a formatted warning text if user unloadds this plugin or QString::null 
		*/
		virtual QString unloadWarning() const;
		/**
		* Gives a reference to the toplevel widget.
		*/
		KBearMainWindowInterface* mainWindow();
		/**
		* Gives a reference to the application core
		*/
		KBearCore* core();
	public slots:
		/**
		* Reimplement this to initialize your plugin. The slot is automatically connected to
		* @ref KBearCore::initialized signal so no need to do that.
		*/
		virtual void slotInit() = 0;
		/**
		* Reimplement this if your plugin have aconfiguration widget that should be added to the configuration dialog.
		* Do like this:
		* <pre>
		*	void MyClass::slotConfigWidget(KDialogBase *dlg) {
		*	QVBox *vbox = dlg->addVBoxPage( i18n("PLUGIN NAME"));
		* 	PLUGINWIDGET *w = new PLUGINWIDGET(vbox, "name");
		* }
		* </pre>
		* and whatever else you need.
		* The slot is automatically connected to @ref KBearCore::configWidget signal so no need to do that.
		* Default implementation does nothing
		*/
		virtual void slotConfigWidget( KDialogBase* ) {}
		/**
		* Reimplement this if your plugin have aconfiguration widget that should be added to the wizard.
		* Do like this:
		* <pre>
				void MyClass::slotConfigWidget(KWizard* wiz) {
			* 	PLUGINWIDGET* w = new PLUGINWIDGET(vbox, "name");
			*	wiz->addPage( w, i18n("PLUGIN NAME") );
			*	}
		* </pre>
		* and whatever else you need.
		* The slot is automatically connected to @ref KBearCore::configWidget signal so no need to do that.
		* Default implementation does nothing
		*/
		virtual void slotConfigWidget( KWizard* ) {}
	protected:
		KBearAPI* m_api;
	};
};
#endif
