/*********************************************************************************
* C++ Implementation: misc.cpp
* Description:
*
* Begin : lr jan 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// KDE specific include files


//////////////////////////////////////////////////////
// Qt specific includes
#include <qtextstream.h>
#include <qmap.h>
#include <qstring.h>
#include <qpoint.h>
#include <qcstring.h>
#include <qpixmapcache.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kfileview.h>
#include <kfileitem.h>
#include <kurldrag.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kurl.h>
#include <kparts/componentfactory.h>
#include <kparts/part.h>
#include <kguiitem.h>
#include <kmessagebox.h>
///////////////////////////////////////////////////////
// System specific includes
#include <X11/Xlib.h>
#include <string.h>
#include <netdb.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "misc.h"
#include "connectionmanager.h"

namespace KBear {

//-----------------------------------------------
const char* uninitialized_xpm[] = {
	"11 11 2 1",
	". c None",
	"# c #ff0000",
	"..######...",
	".########..",
	".###..###..",
	".##....##..",
	"......###..",
	".....###...",
	"...####....",
	"...###.....",
	"...........",
	"...###.....",
	"...###....."
};
//-----------------------------------------------
const char* stopped_xpm[] = {
	"11 11 5 1",
	". c None",
	"# c #313062",
	"a c #6261cd",
	"b c #c50000",
	"c c #ff8583",
	"...........",
	"...####....",
	".a#bbbb#a..",
	".#ccbbbb#..",
	"#bccbbbbb#.",
	"#bbbbbbbb#.",
	"#bbbbbbcb#.",
	"#bbbbbccb#.",
	".#bbbccb#..",
	".a#bbbb#a..",
	"...####...."
};
//-----------------------------------------------
const char* paused_xpm[] = {
	"11 11 5 1",
	". c None",
	"b c #3100c5",
	"# c #313062",
	"c c #3189ff",
	"a c #6265cd",
	"...........",
	"...####....",
	".a#bbbb#a..",
	".#ccbbbb#..",
	"#bccbbbbb#.",
	"#bbbbbbbb#.",
	"#bbbbbbcb#.",
	"#bbbbbccb#.",
	".#bbbccb#..",
	".a#bbbb#a..",
	"...####...."
};
//-----------------------------------------------
const char *started_xpm[]={
	"11 11 5 1",
	". c None",
	"b c #00c000",
	"c c #00ff00",
	"# c #313062",
	"a c #6261cd",
	"...........",
	"...####....",
	".a#bbbb#a..",
	".#ccbbbb#..",
	"#bccbbbbb#.",
	"#bbbbbbbb#.",
	"#bbbbbbcb#.",
	"#bbbbbccb#.",
	".#bbbccb#..",
	".a#bbbb#a..",
	"...####...."
};
//-----------------------------------------------
const char* queued_xpm[] = {
	"11 11 5 1",
	". c None",
	"# c #313062",
	"a c #6261cd",
	"b c #c5c600",
	"c c #ffff41",
	"...........",
	"...####....",
	".a#bbbb#a..",
	".#ccbbbb#..",
	"#bccbbbbb#.",
	"#bbbbbbbb#.",
	"#bbbbbbcb#.",
	"#bbbbbccb#.",
	".#bbbccb#..",
	".a#bbbb#a..",
	"...####...."
};
//-----------------------------------------------
static const char* progress_base_xpm[] = {
	"100 16 2 1",
	"# c #ededed",
	". c #0058c0",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
	"....................................................................................................",
};
//-----------------------------------------------
QString encodePassword( const QString& password ) {
	QString pass = password;
	QTextStream sStream( &pass, IO_ReadOnly );
	QCString bArray;
	sStream >> bArray;
	QCString result = KCodecs::base64Encode( bArray, true );
	return result.data();
}
//-----------------------------------------------
QString decodePassword( const QString& pass ) {
	QString p = pass;
	QCString dataIn;
	QTextStream sStream( &p, IO_ReadOnly );
	sStream >> dataIn;
	QCString result = KCodecs::base64Decode( dataIn );
	return result.data();
}
//-----------------------------------------------
bool isModifierKeysPressed( unsigned int mask ){
	Window root;
	Window child;
	int root_x, root_y, win_x, win_y;
	unsigned int keybstate;
	XQueryPointer( qt_xdisplay(), qt_xrootwin(), &root, &child, &root_x, &root_y, &win_x, &win_y, &keybstate );
	return keybstate & mask;
}
//-----------------------------------------------
KURLDrag* createDragObject( int ID, KFileView* fileView, int iconSize ) {
	// create a list of the URL:s that we want to drag
	KURL::List urls;
	QMap<QString, QString> metaData;
	KFileItemListIterator it( * fileView->KFileView::selectedItems() );
	QPixmap pixmap =it.current()->pixmap( iconSize );
	for ( ; it.current(); ++it ){
		urls.append( (*it)->url() );
		metaData.insert( (*it)->url().url(), (*it)->mimetype() );
	}
	if( urls.count() > 1 )
		pixmap = DesktopIcon( "kmultiple", iconSize );

	QPoint hotspot;
	hotspot.setX( pixmap.width() / 2 );
	hotspot.setY( pixmap.height() / 2 );

	metaData.insert( "SourceID", QString::number( ID ) );
	KURLDrag* dragObject = KURLDrag::newDrag( urls, metaData, fileView->widget()->parentWidget() );

	dragObject->setPixmap( pixmap, hotspot );

	return dragObject;
}
//-----------------------------------------------
QPixmap createProgressPixmap( int progress ) {
	QPixmap pixmap;
	QString key = QString::number( progress );
	if( ! QPixmapCache::find( key, pixmap ) ) {
		char tmp[ 101 ];

		memset( &tmp[ 0 ], '.', progress );
		memset( &tmp[ progress ], '#', 100 - progress );
		tmp[ 101] = '\0';

		for( int i = 3; i < 19; i++ ) {
			(char*)progress_base_xpm[ i ] = tmp;
		}

		pixmap = QPixmap( (const char**) progress_base_xpm );
		QPixmapCache::insert( key, pixmap );
	}
	return pixmap;
}
//-----------------------------------------------
int getPortForProtocol( const QString &protocol ) {
	char p[25];
	int port = 0;
	strcpy( p, "ssh" );
	if( protocol != "sftp" && protocol != "fish" ) // ssh protocols
		strcpy( p, protocol.latin1() );
	setservent( true );  // open /etc/services
	struct servent* serv = getservbyname( p, NULL );   // find default port for specified protocol
	if( serv ) {
		port = (int)ntohs( (unsigned short int)serv->s_port);
	}
	endservent();  // close /etc/services
	return port;
}
//-----------------------------------------------
}; // end namespace KBear
