/*********************************************************************************
* C++ Interface: misc.h
* Description:
*                              
* Begin : lr jan 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/
 
#ifndef MISC_H
#define MISC_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qstring.h>
#include <qpixmap.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kio/job.h>
#include <kmdcodec.h>
//////////////////////////////////////////////////////
// Application specific includes

class KFileView;
class KURLDrag;

/*
* @author Bjrn Sahlstrm
* Misc convenient methods
*/

namespace KBear {
	/** 
	* @param password should contain the password to encode
	* @return the password encoded using base64
	*/
	extern QString encodePassword( const QString& password );
	/**
	* @param password should contain the password to decode
	* @return the password decoded using base64
	*/
	extern QString decodePassword( const QString& password );
	/**
	* @param mask should contain the mask for the modifier key/keys to check for
	* @return true if the specified modifier key/keys is pressed
	*/
	extern bool isModifierKeysPressed( unsigned int mask );
	/**
	This method creates a @ref KURLDrag from a @ref KFileView s selected items
	in a way suitable for KBear. Use this from your @ref KFileView inherited classes to get a persistent
	way of creating these type of drags.
	*/
	extern KURLDrag* createDragObject( int ID, KFileView*, int iconSize = 16 );
	/**
	This method creates a @ref QPixmap that can be used to display progress
	in for example a @ref QListViewItem. The size of the @ref QPixmap is 100x16.
	@param progress should contain the progress to display
	*/
	extern QPixmap createProgressPixmap( int progress );

	int getPortForProtocol( const QString &protocol );
	/**
	* This enum represents the different ChildFrame modes
	*/
	enum {
		Cascade,
		CascadeMaximized,
		ExpandVertical,
		ExpandHorizontal,
		AnodinesTile,
		PragmasTile,
		TileVertically,
		NoMode
	};
	/**
	* This enum represents the different transfer modes
	*/
	enum TransferMode {
		Binary = 0,
		Ascii = 1,
		Auto = 2
	};
	/**
	* Enum for representing time intervalls over time
	*/
	enum Intervall {
		MINUTE = 0,
		HOUR = 1,
		DAY=2,
		WEEK=3,
		MONTH=4,
		YEAR = 5,
		NEVER=10
	};
//-----------------------------------------------
	extern const char* uninitialized_xpm[ 14 ];
	extern const char* stopped_xpm[ 17 ];
	extern const char* paused_xpm[ 17 ];
	extern const char *started_xpm[ 17 ];
	extern const char* queued_xpm[ 17 ];
};

#endif

