/*********************************************************************************
* C++ Implementation: sitechildsingleconnection.cpp
* Description:
*
* Begin : mn jun 2 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/slave.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "sitechildsingleconnection.h"

using namespace KBear;

#include "sitechildsingleconnection.moc"
//-----------------------------------------------
SiteChildSingleConnection::SiteChildSingleConnection( TopLevelConnectionInterface* parent, const SiteInfo& info )
	:	ChildSingleConnection( parent, info ),
		ChildConnection( parent, info )
{
}
//-----------------------------------------------
SiteChildSingleConnection::~SiteChildSingleConnection() {
}
//-----------------------------------------------
bool SiteChildSingleConnection::openConnection() {
	KIO::Slave* slave = m_parentConnection->getSlave();
	if( slave )
		QTimer::singleShot( 0, this, SLOT( slotConnected() ) );
	return ( slave != 0L );
}
//-----------------------------------------------
void SiteChildSingleConnection::addConnection( ConnectionInterface* connection ) {
	if( ! connection )
		return;
	// we don't add the connection to ourself, instead we add it to our parent
	m_parentConnection->addConnection( connection );
}
//-----------------------------------------------
void SiteChildSingleConnection::removeConnection( ConnectionInterface* connection ) {
	if( ! connection )
		return;

	m_parentConnection->removeConnection( connection );
}
//-----------------------------------------------
void SiteChildSingleConnection::slotConnectionClosed( int ) {
	//dummy
}
//-----------------------------------------------
void SiteChildSingleConnection::slotInfoMessage( int, const QString& ) {
	// dummy
}
//-----------------------------------------------
