/***************************************************************************
                          siteinfo.cpp  -  description
                             -------------------
    begin                : sn jan 12 2003
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdir.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"
#include "kbeartags.h"
#include "kbeardomhelper.h"


using namespace KBear;
//-----------------------------------------------
SiteInfo::SiteInfo()
	:	m_ID( -1 )
{
	setContent( QString("<%1>").arg( TAG_SITE ) );
	QDomElement doc = documentElement();
	doc.setAttribute( ATT_LABEL, i18n("No Name") );
	KBearDomHelper::addTextNode( *this, doc, TAG_PROTOCOL, QString::fromLatin1( "ftp" ) );
	KBearDomHelper::addTextNode( *this, doc, TAG_HOST, QString::null );
	KBearDomHelper::addTextNode( *this, doc, TAG_PORT, QString::number( 21 ) );
	KBearDomHelper::addEmptyElement( *this, doc, TAG_ANONYMOUS );
	KBearDomHelper::addTextNode( *this, doc, TAG_USER, QString::fromLatin1( "anonymous" ) );
	KBearDomHelper::addTextNode( *this, doc, TAG_PASS, QString::null );
	KBearDomHelper::addTextNode( *this, doc, TAG_REMOTE_PATH, QString::fromLatin1("/") );
	KBearDomHelper::addTextNode( *this, doc, TAG_LOCAL_PATH, QDir::homeDirPath() );
	QDomElement tmpElement = KBearDomHelper::addEmptyElement( *this, doc, TAG_AUTO_RECONNECT );
	tmpElement.setAttribute( ATT_SLEEP, QString::fromLatin1( "30" ) );
	tmpElement.setAttribute( ATT_COUNT, QString::fromLatin1( "10" ) );
	tmpElement = KBearDomHelper::addEmptyElement( *this, doc, TAG_FILESYS_ENCODING );
	tmpElement.setAttribute( ATT_ENCODING, QString::fromLatin1( "iso 8859-1" ) );

	setParent( QString::null );
	KBearDomHelper::addTextNode( *this, doc, TAG_DESCRIPTION, QString::null );
}
//-----------------------------------------------
SiteInfo::SiteInfo( const SiteInfo& info )
	: QDomDocument()
{
	m_ID = info.ID();
	setContent( info.toString() );
}
//-----------------------------------------------
SiteInfo::SiteInfo( const KURL& url )
	:	m_ID( -1 )
{
	setContent( QString("<%1>").arg( TAG_SITE ) );
	QDomElement doc = documentElement();
	doc.setAttribute( ATT_LABEL, ( url.hasHost() ? url.host() : i18n("No Name") ) );
	KBearDomHelper::addTextNode( *this, doc, TAG_PROTOCOL, url.protocol() );
	KBearDomHelper::addTextNode( *this, doc, TAG_HOST, ( url.hasHost() ? url.host() : QString::null ) );
	KBearDomHelper::addTextNode( *this, doc, TAG_PORT, QString::number( (url.port()>0) ? url.port() : 21 ) );
	KBearDomHelper::addEmptyElement( *this, doc, TAG_ANONYMOUS );
	KBearDomHelper::addTextNode( *this, doc, TAG_USER, ( url.hasUser() ? url.user() : QString::null ) );
	KBearDomHelper::addTextNode( *this, doc, TAG_PASS, ( url.hasPass() ? url.pass(): QString::null ) );
	KBearDomHelper::addTextNode( *this, doc, TAG_REMOTE_PATH, ( url.hasPath() ? url.path() : QString::fromLatin1("/") ) );
	KBearDomHelper::addTextNode( *this, doc, TAG_LOCAL_PATH, QDir::homeDirPath() );
	QDomElement tmpElement = KBearDomHelper::addEmptyElement( *this, doc, TAG_AUTO_RECONNECT );
	tmpElement.setAttribute( ATT_SLEEP, QString::fromLatin1( "30" ) );
	tmpElement.setAttribute( ATT_COUNT, QString::fromLatin1( "10" ) );
	tmpElement = KBearDomHelper::addEmptyElement( *this, doc, TAG_FILESYS_ENCODING );
	tmpElement.setAttribute( ATT_ENCODING, QString::fromLatin1( "iso 8859-1" ) );

	setParent( QString::null );
	KBearDomHelper::addTextNode( *this, doc, TAG_DESCRIPTION, QString::null );
}
//-----------------------------------------------
SiteInfo::SiteInfo( const QString& c )
	:	m_ID( -1 )
{
	setContent( c );
}
//-----------------------------------------------
SiteInfo::~SiteInfo() {
}
//-----------------------------------------------
QString SiteInfo::parent() const { 
	return documentElement().attribute( ATT_PARENT );
}
//-----------------------------------------------
QString SiteInfo::description() const { 
	return KBearDomHelper::getNodeValue( documentElement(), TAG_DESCRIPTION );
}
//-----------------------------------------------
void SiteInfo::setParent( const QString& p ) { 
	documentElement().setAttribute( ATT_PARENT, p );
}
//-----------------------------------------------
void SiteInfo::setDescription( const QString& d ) {
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_DESCRIPTION, d );
}
//-----------------------------------------------
bool SiteInfo::isLocal() const {
	QString tmp = KBearDomHelper::getNodeValue( documentElement(), TAG_HOST );
	return tmp.isEmpty();
}
//-----------------------------------------------
QString SiteInfo::label() const {
//	kdDebug()<<"ATT_LABEL="<<ATT_LABEL<<" SiteInfo::label()="<<documentElement().attribute( ATT_LABEL )<<endl;
	return documentElement().attribute( ATT_LABEL );
}
//-----------------------------------------------
void SiteInfo::setLabel( const QString& label ) {
	documentElement().setAttribute( ATT_LABEL, label );
}
//-----------------------------------------------
KURL SiteInfo::url() const {
	KURL url;
	url.setProtocol( protocol() );
	url.setHost( host() );
	url.setPort( port() );
	url.setUser( user() );
	url.setPass( pass() );
	if( url.hasHost() )
		url.setPath( remotePath() );
	else
		url.setPath( QDir::homeDirPath() );
	return url;
}
//-----------------------------------------------
QString SiteInfo::protocol() const {
//	kdDebug()<<"TAG_PROTOCOL="<<TAG_PROTOCOL<<" SiteInfo::protocol()="<<KBearDomHelper::getNodeValue( documentElement(), TAG_PROTOCOL )<<endl;
	return KBearDomHelper::getNodeValue( documentElement(), TAG_PROTOCOL );
}
//-----------------------------------------------
QString SiteInfo::host() const {
	return KBearDomHelper::getNodeValue( documentElement(), TAG_HOST );
}
//-----------------------------------------------
int SiteInfo::port() const {
	return KBearDomHelper::getNodeValue( documentElement(), TAG_PORT ).toInt();
}
//-----------------------------------------------
QString SiteInfo::user() const {
	return KBearDomHelper::getNodeValue( documentElement(), TAG_USER );
}
//-----------------------------------------------
QString SiteInfo::pass() const {
	return KBearDomHelper::getNodeValue( documentElement(), TAG_PASS );
}
//-----------------------------------------------
QString SiteInfo::remotePath() const {
	return KBearDomHelper::getNodeValue( documentElement(), TAG_REMOTE_PATH );
}
//-----------------------------------------------
QString SiteInfo::localPath() const {
	return KBearDomHelper::getNodeValue( documentElement(), TAG_LOCAL_PATH );
}
//-----------------------------------------------
QString SiteInfo::listCommand() const {
	QString s = KBearDomHelper::getNodeValue( documentElement(), TAG_LIST_COMMAND );
	if( s.isEmpty() ) s = "list -a";
	return s;
}
//-----------------------------------------------
bool SiteInfo::anonym() const {
	// Tag exists if we should USE anonymous login
	return ! KBearDomHelper::getElement( documentElement(), TAG_ANONYMOUS ).isNull();
}
//-----------------------------------------------
bool SiteInfo::passiveMode() const {
	// Tag exists if we should DISABLE PASV
	return KBearDomHelper::getElement( documentElement(), TAG_DISABLE_PASV ).isNull();
}
//-----------------------------------------------
bool SiteInfo::extendedPassiveMode() const {
	// Tag exists if we should DISABLE EPASV
	return KBearDomHelper::getElement( documentElement(), TAG_DISABLE_EPASV ).isNull();
}
//-----------------------------------------------
/* Removed since this is now a globally option
bool SiteInfo::binaryMode() const {
	// Tag exists if we should USE ASCII
	return KBearDomHelper::getElement( documentElement(), TAG_ASCII ).isNull();
}
*/
//-----------------------------------------------
bool SiteInfo::enableLog() const {
	// Tag exists if we should DISABLE Log
	return KBearDomHelper::getElement( documentElement(), TAG_DISABLE_LOG ).isNull();
}
//-----------------------------------------------
bool SiteInfo::markPartial() const {
	// Tag exists if we should USE mark partial
	return ! KBearDomHelper::getElement( documentElement(), TAG_MARK_PARTIAL ).isNull();
}
//-----------------------------------------------
bool SiteInfo::autoReconnect() const {
	// Tag exists if we should USE auto reconnect
	return ! KBearDomHelper::getElement( documentElement(), TAG_AUTO_RECONNECT ).isNull();
}
//-----------------------------------------------
int SiteInfo::reconnectTime() const {
	return KBearDomHelper::getAttribute( documentElement(), TAG_AUTO_RECONNECT, ATT_SLEEP ).toInt();
}
//-----------------------------------------------
int SiteInfo::numOfRetries() const {
	return KBearDomHelper::getAttribute( documentElement(), TAG_AUTO_RECONNECT, ATT_COUNT ).toInt();
}
//-----------------------------------------------
/* Removed since this is now a globally option
bool SiteInfo::queue() const {
	// Tag exists if we should USE queue
	return ! KBearDomHelper::getElement( documentElement(), TAG_QUEUE ).isNull();
}
*/
//-----------------------------------------------
bool SiteInfo::singleConnection() const { 
	// Tag exists if we should USE a single connection
	return ! KBearDomHelper::getElement( documentElement(), TAG_SINGLE_CONNECTION ).isNull();
}
//-----------------------------------------------
QString SiteInfo::fileSysEncoding() const {
	QString tmp = KBearDomHelper::getAttribute( documentElement(), TAG_FILESYS_ENCODING, ATT_ENCODING );
	return ( tmp.isEmpty() ? QString::fromLatin1( "iso 8859-1" ) : tmp );
}
//-----------------------------------------------
void SiteInfo::setProtocol( const QString& protocol ) {
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_PROTOCOL, protocol );
}
//-----------------------------------------------
void SiteInfo::setHost( const QString& host ) {
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_HOST, host );
}
//-----------------------------------------------
void SiteInfo::setPort( int port ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_PORT, QString::number( port ) );
}
//-----------------------------------------------
void SiteInfo::setUser( const QString& user ) {
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_USER, user );
}
//-----------------------------------------------
void SiteInfo::setPass( const QString& pass ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_PASS, pass );
}
//-----------------------------------------------
void SiteInfo::setRemotePath( const QString& path ) {
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_REMOTE_PATH, path );
}
//-----------------------------------------------
void SiteInfo::setLocalPath( const QString& path ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_LOCAL_PATH, path );
}
//-----------------------------------------------
void SiteInfo::setListCommand( const QString &cmd ) {
	QDomElement parent = documentElement();
	KBearDomHelper::setNodeValue( *this, parent, TAG_LIST_COMMAND, cmd );
}
//-----------------------------------------------
void SiteInfo::setAnonym( bool anonym ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_ANONYMOUS, ! anonym );
}
//-----------------------------------------------
void SiteInfo::setPassiveMode( bool pasv ) {
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_DISABLE_PASV, ! pasv );
}
//-----------------------------------------------
void SiteInfo::setExtendedPassiveMode( bool epasv ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_DISABLE_EPASV, ! epasv );
}
//-----------------------------------------------
/* Removed since this is now a globally option
void SiteInfo::setBinaryMode( bool binary ) {
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_ASCII, ! binary );
}
*/
//-----------------------------------------------
void SiteInfo::setEnableLog( bool log ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_DISABLE_LOG, log );
}
//-----------------------------------------------
void SiteInfo::setMarkPartial( bool partial ) {
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_MARK_PARTIAL, partial );
}
//-----------------------------------------------
void SiteInfo::setAutoReconnect( bool r ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_AUTO_RECONNECT, r );
}
//-----------------------------------------------
void SiteInfo::setReconnectTime( int t ) {
	if( ! autoReconnect() ) // we can't set the time if reconnect is turned OFF
		return;
		
	KBearDomHelper::setAttribute( documentElement(), TAG_AUTO_RECONNECT, ATT_SLEEP, QString::number( t ) );
}
//-----------------------------------------------
void SiteInfo::setNumOfRetries( int n ) { 
	if( ! autoReconnect() ) // we can't set the number if reconnect is turned OFF
		return;

	KBearDomHelper::setAttribute( documentElement(), TAG_AUTO_RECONNECT, ATT_COUNT, QString::number( n ) );
}
//-----------------------------------------------
/* Removed since this is now a globally option
void SiteInfo::setQueue( bool q ) {
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_QUEUE, q );
}
*/
//-----------------------------------------------
void SiteInfo::setSingleConnection( bool s ) { 
	QDomElement parent = documentElement();
	KBearDomHelper::createBoolValue( *this, parent, TAG_SINGLE_CONNECTION, s );
}
//-----------------------------------------------
void SiteInfo::setFileSysEncoding( const QString& e ) {
	QDomElement parent = documentElement();	
	KBearDomHelper::setAttribute( parent, TAG_FILESYS_ENCODING, ATT_ENCODING, e );
}
//-----------------------------------------------
void SiteInfo::insert( QDataStream& out ) const {
	out << toString();
}
//-----------------------------------------------
void SiteInfo::extract( QDataStream& in )  {
	QString tmp;
	in >> tmp;
	setContent( tmp );
	QDomElement doc = documentElement();
	doc.setTagName( TAG_SITE );
}
//-----------------------------------------------
