/***************************************************************************
                          siteinfo.h  -  description
                             -------------------
    begin                : sn jan 12 2003
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SITEINFO_H
#define SITEINFO_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdom.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/global.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files


namespace KBear {
/**
  *@author Bjrn Sahlstrm
  */
	class SiteInfo : public QDomDocument {
		friend class ConnectionManager;
	public:
		/** */
		SiteInfo();
		/** */
		SiteInfo( const SiteInfo& );
		/** */
		SiteInfo( const KURL& );
		/** */
		SiteInfo( const QString& );
		/** */
		~SiteInfo();
		/** @return users login name for the remote host */
		QString parent() const;
		/** @return users login name for the remote host */
		QString description() const;
		/**  */
		void setParent( const QString& p );
		/**  */
		void setDescription( const QString& d );
		/** @return the ID for this connection. This ID is used to identify the connection in various situations.
		* By default set to -1. Can only be changed byt the @ref KBear::ConnectionManager */
		const int ID() const { return m_ID; }
		/** @return an URL representing the contents of the connection */
		KURL url() const;
		/** @return whether the connection is for local file system*/
		bool isLocal() const;
		/** @return Label for the site */
		QString label() const;
		/** @return Name of the server to connect to, like ftp.kde.org */
		QString protocol() const;
		/** @return Name of the server to connect to, like ftp.kde.org */
		QString host() const;
		/** @return port number to connect to*/
		int port() const;
		/** @return users login name for the remote host */
		QString user() const;
		/** @return users password for the remote host */
		QString pass() const;
		/** @return Initial path for the remote host */
		QString remotePath() const;
		/** @return Initial path for the localhost */
		QString localPath() const;
		/** @return whether to use anonymous login or not*/
		bool anonym() const;
		/** @return whether to use passivemode (PASV)or not*/
		bool passiveMode() const;
		/** @return whether to use passivemode (EPSV)or not*/
		bool extendedPassiveMode() const;
		/** @return whether to use binary/ASCII mode ( binary=true, ASCII=false)*/
/* Removed since this is now a globally option
		bool binaryMode() const;
*/
		/** @return whether to use log or not*/
		bool enableLog() const;
		/** @return whether to use *.part extensions or not*/
		bool markPartial() const;
		/** @return the command used for listing directories*/
		QString listCommand() const;
		/** @return if auto reconnect is tuned on or off */
		bool autoReconnect() const;
		/** @return number of seconds before trying to reconnect */
		int reconnectTime() const;
		/** @return number of times to try to reconnect */
		int numOfRetries() const;
/* Removed since this is now a globally option
		bool queue() const;
*/
		/** @return if a single connection is to be used for filesys operations */
		bool singleConnection() const;
		/** */
		QString fileSysEncoding() const;
		/** Set label for the site */
		void setLabel( const QString& label );
		/** Set name of the server to connect to, like ftp.kde.org */
		void setProtocol( const QString& protocol );
		/** Set name of the server to connect to, like ftp.kde.org */
		void setHost( const QString& host );
		/** Set port number to connect to*/
		void setPort( int port );
		/** Set whether to use anonymous login or not*/
		void setAnonym( bool anonym );
		/** Set whether to use passivemode (PASV) or not*/
		void setPassiveMode( bool passive );
		/** Set whether to use passivemode (EPSV) or not*/
		void setExtendedPassiveMode( bool e_passive );
		/** Set whether to use passivemode or not*/
/* Removed since this is now a globally option
		void setBinaryMode( bool binary );
*/
		/** Set whether to enable log or not*/
		void setEnableLog( bool log );
		/** Set whether to use *.part extensions or not*/
		void setMarkPartial( bool part );
		/** Set the command to list directories*/
		void setListCommand( const QString &cmd );
		/** Set users login name for the remote host */
		void setUser( const QString& user );
		/** Set users password for the remote host */
		void setPass( const QString& pass );
		/** Set initial path for the remote host */
		void setRemotePath( const QString& remotePath );
		/** Set initial path for the localhost */
		void setLocalPath( const QString& localPath );
		/** Set if autmatic reconnect on failure */
		void setAutoReconnect( bool r );
		/** Set number of seconds before tying to reconnect */
		void setReconnectTime( int t );
		/** Set number of times to try to reconnect */
		void setNumOfRetries( int n );
/* Removed since this is now a globally option
		void setQueue( bool q );
*/
		/** Set if a single connection is to be used for filesys operations, default is false */
		void setSingleConnection( bool s );
		/** */
		void setFileSysEncoding( const QString& e );
		/** */
		virtual void extract( QDataStream& in );
		/** */
		virtual void insert( QDataStream& out ) const;
	protected:
		/** IMPORTANT this method should only be used by the @ref KBearConnectionManager */
		void setID( int id ) { m_ID = id; }
	protected:
		int m_ID;
	};
};
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s, const KBear::SiteInfo& site ) {
	site.insert( s );
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, KBear::SiteInfo& site ) {
	site.extract( s );
	return s;
}
///////////////////////////////////////////////////////
#endif
