/*********************************************************************************
* C++ Interface: transfer.h
* Description:
*
* Begin : ons maj 7 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARTRANSFER_H
#define KBEARTRANSFER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qguardedptr.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kurl.h>
#include <kio/job.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"

class KBearCopyJob;

namespace KBear {
	class TransferGroup;

	/**
	@author Bjrn Sahlstrm
	*/
	class Transfer : public QObject {
			Q_OBJECT
			friend class TransferManager;
		public:
			/** */
			enum Status {
				Uninitialized = 1,
				Started = 2,
				Stopped = 4,
				Paused = 8,
				Queued = 16,
				Canceled = 32,
				Finished = 64
			};
			/** */
			enum Command {
				Start,
				Stop,
				Pause,
				Resume,
				Queue,
				Cancel,
				Die
			};
			/** */
			enum Type{ 	Copy = 10, Move = 11 };
			/** */
			~Transfer();
			/** */
			QString mimetype() const { return m_mimetype; }
			/** */
			unsigned int type() const { return m_type; }
			/** */
			unsigned int status() const { return m_status; }
			/** */
			KURL::List sourceURLs() const { return m_sourceURLs; }
			/** */
			KURL destURL() const { return m_destURL; }
			/** */
			int sourceID() const { return m_sourceInfo.ID(); }
			/** */
			int destID() const { return m_destInfo.ID(); }
			/** */
			long transferID() const { return m_transferID; }
			/** */
			SiteInfo sourceInfo() const { return m_sourceInfo; }
			/** */
			SiteInfo destInfo() const { return m_destInfo; }
			/** */
			KBear::TransferGroup* group() const { return m_group; }
			/** */
			KIO::filesize_t size() const { return m_size; }
			/** */
			int progress() const { return m_progress; }
			/** */
			void setOverWrite( bool overwrite = true );
			/** */
			void setSkip( bool skip = true );
		signals:
			void finished();
			void percent( long, unsigned long );
			void totalDirs( long, unsigned long );
			void totalFiles( long, unsigned long );
			void processedFiles( long, unsigned long );
			void processedDirs( long, unsigned long );
			void copying( long, const KURL&, const KURL& );
			void moving( long, const KURL&, const KURL& );
			void creatingDir( long, const KURL& );
			void renamed( long, const KURL&, const KURL& );
			void totalSize( long, KIO::filesize_t );
			void processedSize( long, KIO::filesize_t );
			void speed( long, unsigned long );
			void statusChanged( long, unsigned int );
			void newIDs( int sourceID, int destID );
		protected:
			/** */
			Transfer( TransferGroup*, int ID, int sourceID, int destID, unsigned int, const QString& mimetype=QString::null );
			/** */
			Transfer( TransferGroup* group, int ID, const SiteInfo& sInfo, const SiteInfo& dInfo, unsigned int type, const QString& mimetype );
			/** */
			void setSourceURLs( const KURL::List& );
			/** */
			void setDestURL( const KURL& );
			/** */
			void setCommand( unsigned int cmd );
		private slots:
			void slotPercent( KIO::Job *job, unsigned long percent );
			void slotTotalDirs( KIO::Job *, unsigned long dirs );
			void slotTotalFiles( KIO::Job *, unsigned long files );
			void slotProcessedFiles( KIO::Job *, unsigned long files );
			void slotProcessedDirs( KIO::Job *, unsigned long dirs );
			void slotCopying( KIO::Job *, const KURL& from, const KURL& to );
			void slotMoving( KIO::Job *, const KURL& from, const KURL& to );
			void slotCreatingDir( KIO::Job *, const KURL& dir );
			void slotRenamed( KIO::Job *, const KURL& from, const KURL& to );
			void slotCanceled( KIO::Job* );
			void slotTotalSize( KIO::Job *, KIO::filesize_t size );
			void slotProcessedSize( KIO::Job *, KIO::filesize_t size );
			void slotSpeed( KIO::Job *, unsigned long bytes_per_second );
			void slotResult( KIO::Job* job );
		private:
			void connectJob();
			void setStatus( unsigned int );
		private:
			class TransferPrivate;
			TransferPrivate* d;
			KURL::List m_sourceURLs;
			KURL m_destURL;
			int m_sourceID;
			int m_destID;
			int m_transferID;
			unsigned int m_status;
			unsigned int m_type;
			QString m_mimetype;
			QGuardedPtr<KBearCopyJob> m_job;
			TransferGroup* m_group;
			bool m_autoSkip;
			bool m_overwriteAll;
			KIO::filesize_t m_size;
			int m_progress;
			SiteInfo m_sourceInfo;
			SiteInfo m_destInfo;
	};

};

#endif
