/*********************************************************************************
* C++ Implementation: kbearsynchjob.cpp
* Description:
*
* Begin : Sun Jun 29 2003
* Author : Frithjof Engel <frithjof_engel@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/job.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// application specific include files
#include "kbearsynchjob.h"
#include "kbearcopyjob.h"
#include "kbeardeletejob.h"
#include "kbearlistjob.h"

using namespace KBear;

#include "kbearsynchjob.moc"

KBearSynchJob::KBearSynchJob( int dID, int sID, const KURL& src, const KURL& dest )
  : KIO::Job(false), m_srcList( src ), m_dest( dest ),
    m_destID( dID ), m_sourceID( sID )

{
	makeSourceList( m_srcList );
}

KBearSynchJob::KBearSynchJob( const KURL::List& src, const KURL& dest, bool srcIsRoot )
  : KIO::Job(false), m_srcList( src ), m_dest( dest ),
    m_destID( -1 ), m_sourceID( -1 ), m_srcIsRoot( srcIsRoot )

{
	makeSourceList( m_srcList );
}

void KBearSynchJob::slotStart()
{
	KBearCopyJob *job = new KBearCopyJob( m_srcList, m_dest, KBearCopyJob::Copy, false );
	job->setOverwriteAll();
	connect( job, SIGNAL( result( KIO::Job* ) ), this, SIGNAL( result( KIO::Job* ) ) );
// 	connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotEnd() ) );
	connect( job, SIGNAL( totalSize( KIO::Job*, KIO::filesize_t ) ),
		this, SIGNAL( totalSize( KIO::Job*, KIO::filesize_t ) ) );
	connect( job, SIGNAL( processedSize( KIO::Job*, KIO::filesize_t ) ),
		this, SIGNAL( processedSize( KIO::Job*, KIO::filesize_t ) ) );
	connect( job, SIGNAL( totalFiles( KIO::Job*, unsigned long ) ),
		this, SIGNAL( totalFiles( KIO::Job*, unsigned long )  ) );
	connect( job, SIGNAL( processedFiles( KIO::Job*, unsigned long ) ),
		this, SIGNAL( processedFiles( KIO::Job*, unsigned long ) ) );
	job->slotStart( m_sourceID, m_destID );
}

void KBearSynchJob::slotEnd() {
/*	// A directory named like the host is created when the root of a host is copied. So we have to remove it. TODO: Fix this!
	KURL url = KURL( m_dest.prettyURL() + "/" + m_srcList.first().prettyURL() );
	if( m_srcIsRoot ) {
		KBearDeleteJob* job =  KBearDeleteJob::del( url, true, false );
		job->setAutoErrorHandlingEnabled( true, 0 );
		job->start( m_sourceID );
	}	*/
}

void KBearSynchJob::makeSourceList( KURL::List& srcList ) {
	KURL::List::Iterator it = srcList.begin();
	for( ; it != srcList.end(); it++ ) {
		KBearListJob* job = KBearListJob::listDir( m_sourceID, *it, false, false );
		job->setAutoErrorHandlingEnabled( true, (QWidget*)parent() );
		ConnectionManager::getInstance()->attachJob( m_sourceID, job );
		connect( job, SIGNAL( entries( KIO::Job*, const KIO::UDSEntryList & ) ),
			this, SLOT( slotEntries( KIO::Job*, const KIO::UDSEntryList & ) ) );
		connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( slotStart() ) );
	}
}

void KBearSynchJob::slotEntries( KIO::Job* job, const KIO::UDSEntryList& entryList) {
	m_srcList.clear();
	KIO::UDSEntryListConstIterator it = entryList.begin();
	KURL root = static_cast<KIO::ListJob*>(job)->url();
	root.adjustPath(+1);
	for( ; it != entryList.end(); it++ ) {
		KIO::UDSEntry::ConstIterator entit = (*it).begin();
		QString name;
		for( ; entit != (*it).end(); ++entit ) {
			 if( (*entit).m_uds == KIO::UDS_NAME ) {
				name = (*entit).m_str;
				break;
			}
		}
		Q_ASSERT( !name.isEmpty() );
		KIO::ListJob* listjob = static_cast<KIO::ListJob*>(job);
		m_srcList.append( KURL(listjob->url().prettyURL() + name) );
	}
}
