/*********************************************************************************
* C++ Interface: kbearsynchjob.h
* Description:
*
* Begin : Sun Jun 29 2003
* Author : Frithjof Engel <frithjof_engel@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/
#ifndef KBEARSYNCHJOB_H
#define KBEARSYNCHJOB_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/jobclasses.h>
#include <kio/global.h>
//////////////////////////////////////////////////////////////////////
// application specific include files

namespace KBear {

class KBearSynchJob : public KIO::Job {
	Q_OBJECT
public:
	KBearSynchJob( int dID, int sID, const KURL& src, const KURL& dest );
	/**
	   @param src from where to get the file(s)
	   @param dest where to put them
	   @param srcIsRoot set to true if you want to synchronize the root of a server. (i.e. kbearftp://ftp.kde.org/)
	*/
	KBearSynchJob( const KURL::List& src, const KURL& dest, bool srcIsRoot = false );
	KURL::List srcURLs() const { return m_srcList; }
	KURL destURL() const { return m_dest; }
signals:
	void totalFiles( KIO::Job *, unsigned long files );
	void processedFiles( KIO::Job *, unsigned long files );
public slots:
	void slotStart();
private slots:
	void slotEnd();
	void slotEntries( KIO::Job*, const KIO::UDSEntryList& );
private:
	void makeSourceList( KURL::List& srcList );
private:
	KURL::List m_srcList;
	KURL m_dest;
	int m_destID;
	int m_sourceID;
	bool m_srcIsRoot;
};

};
#endif
