/*********************************************************************************
* C++ Implementation: kbeardetailview.cpp
* Description:
*
* Begin : tis jul 1 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kfile.h>
#include <kfileitem.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardetailview.h"
#include "misc.h"

using namespace KBear;

#include "kbeardetailview.moc"
//-----------------------------------------------
KBearDetailView::KBearDetailView( QWidget* parent, const char* name, const SiteInfo& c )
	:	KFileDnDDetailView( parent, name ), m_siteInfo( c )
{
	setViewMode( KFileView::All );
	readConfig( kapp->config(), "View Settings" );
	setSelectionMode( KFile::Extended );
	connect( this, SIGNAL( itemRenamed( QListViewItem*, const QString&, int ) ),
						this, SLOT( slotItemRenamed( QListViewItem*, const QString&, int ) ) );
}
//-----------------------------------------------
KBearDetailView::~KBearDetailView() {
	clearView();
}
//-----------------------------------------------
void KBearDetailView::rename(){
	QListViewItem* item = currentItem();
	if( ! item )
		return;

	KListView::rename( item, 0 );
}
//-----------------------------------------------
void KBearDetailView::slotItemRenamed( QListViewItem* it, const QString& newName, int ) {
	KFileListViewItem* item = dynamic_cast<KFileListViewItem*>( it );
	if( ! item )
		return;

	KFileItem* fileItem = item->fileInfo();
	KURL oldURL = fileItem->url();
	KURL newURL = oldURL;
	newURL.adjustPath( -1 );
	newURL.setFileName( newName );
	if( oldURL == newURL )
		return;

	fileItem->setURL( newURL );

	emit rename( oldURL, newURL );
}
//-----------------------------------------------
void KBearDetailView::startDrag(){
	m_dragObject = KBear::createDragObject( m_siteInfo.ID(), this );
	m_dragObject->drag();   // start the drag
}
//-----------------------------------------------
