/***************************************************************************
                          kbeardirviewitem.cpp  -  description
                             -------------------
    begin                : Tue Jun 6 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdir.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kmessagebox.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardirviewitem.h"

using namespace KBear;

QPixmap* KBearDirViewItem::m_folderHome = 0L;
//-----------------------------------------------
class KBearDirViewItemPrivate {
	public:
};
//-----------------------------------------------
KBearDirViewItem::KBearDirViewItem( QListView* p, const QString& text, KFileItem* fi, bool /*homeDir*/ )
	: 	KBearTreeViewItem ( p, text ), KFileItem( *fi )//, isHome( homeDir )
{
	if( m_folderHome == 0L )
		m_folderHome = new QPixmap(KGlobal::iconLoader()->loadIcon("folder_home", KIcon::Small ));
	KURL u( fi->url() );
	u.setPath( QDir::homeDirPath() );
	if( ( fi->isLocalFile() && u.cmp( fi->url(), true ) ) ) { // || homeDir ) {
		isHome = true;
		setPixmap( *m_folderHome );
	}
	else {
		isHome = false;
		(void)determineMimeType();
		setPixmap( KFileItem::pixmap(16) );
	}
/*
	if( ! fi->isReadable() ) {
		setExpandable( false );
	}
*/
}
//-----------------------------------------------
KBearDirViewItem::KBearDirViewItem( QListViewItem* p,  const QString &text, KFileItem *fi, bool /*homeDir*/ )
	:	KBearTreeViewItem( p, text), KFileItem( *fi )//, isHome( homeDir )
{
	if( m_folderHome == 0L )
		m_folderHome = new QPixmap(KGlobal::iconLoader()->loadIcon("folder_home", KIcon::Small ));
	KURL u( fi->url() );
	u.setPath( QDir::homeDirPath() );
	if( ( fi->isLocalFile() && u.cmp( fi->url(), true ) ) ) { //|| homeDir ) {
		isHome = true;
		setPixmap( *m_folderHome );
	}
	else {
		isHome = false;
		(void)determineMimeType();
		setPixmap( KFileItem::pixmap(16) );
	}
	if( ! fi->isReadable() )
		setExpandable( false );
}
//-----------------------------------------------
void KBearDirViewItem::setOpen( bool o ) {
	if ( ! isExpandable() ) {
		return;
	}
	else if( isHome ){
		setPixmap( *m_folderHome );
	}
	else if( o ) {
		setPixmap( *m_folderOpen );
	}
	else {
		setPixmap( KFileItem::pixmap(16) );
	}
	QListViewItem::setOpen( o );
}
//-----------------------------------------------
