/*********************************************************************************
* C++ Implementation: kbeariconview.cpp
* Description:
*                              
* Begin : ons feb 26 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kfileitem.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kfile.h>
#include <kaction.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeariconview.h"
#include "misc.h"

using namespace KBear;

#include "kbeariconview.moc"
//-----------------------------------------------
KBearIconView::KBearIconView( QWidget* parent, const char* name, const SiteInfo& c )
	:	KFileDnDIconView( parent, name ),
	 m_privateActionCollection( new KActionCollection( 0L, this, "m_privateActionCollection" ) ),
	m_siteInfo( c )
{
	setViewName( i18n("Short View") );
	setViewMode( KFileView::All );
	setupActions();
	readConfig( kapp->config(), "View Settings" );
	setSelectionMode( KFile::Extended );
	setGridX( 85 );
	connect( this, SIGNAL( itemRenamed( QIconViewItem*, const QString& ) ),
						this, SLOT( slotItemRenamed( QIconViewItem*, const QString& ) ) );
}
//-----------------------------------------------
KBearIconView::~KBearIconView() {
	clearView();
}
//-----------------------------------------------
void KBearIconView::startDrag() {
	m_dragObject = KBear::createDragObject( m_siteInfo.ID(), this, iconSize() );
	m_dragObject->drag();   // start the drag
}
//-----------------------------------------------
void KBearIconView::setupActions(){
	new KActionSeparator( m_privateActionCollection, "separator" );
	KToggleAction* action;
	action = new KToggleAction( i18n("Text at the &bottom"), 0,
						this, SLOT( slotTextBottom() ), m_privateActionCollection, "bottom text"  );
	action->setChecked( true );
	action->setExclusiveGroup( "icon text pos" );

	action = new KToggleAction( i18n("Text at the &right"), 0,
						this, SLOT( slotTextRight() ), m_privateActionCollection, "right text"  );
	action->setChecked( false );
	action->setExclusiveGroup( "icon text pos" );

	action = new KToggleAction( i18n("Arrange l&eft to right"), 0,
						this, SLOT( slotFlowEast() ), m_privateActionCollection, "left to right"  );
	action->setChecked( true );
	action->setExclusiveGroup( "icon flow" );

	action = new KToggleAction( i18n("Arrange t&op to bottom"), 0,
						this, SLOT( slotFlowSouth() ), m_privateActionCollection, "top to bottom"  );
 	action->setChecked( false );
	action->setExclusiveGroup( "icon flow" );

	action = new KToggleAction( m_privateActionCollection, "wordwrap text"  );
	action->setText( i18n("&Wordwrap item text") );
	action->setChecked( false );
	connect( action, SIGNAL( toggled ( bool ) ), this, SLOT( slotTextWordWrap( bool ) ) );

	KActionMenu* menu = new KActionMenu( i18n("Icon View Settings"), actionCollection(), "icon view menu");
	menu->insert( m_privateActionCollection->action("small columns") );
	menu->insert( m_privateActionCollection->action("large rows") );
	menu->insert( m_privateActionCollection->action("separator") );
	menu->insert( m_privateActionCollection->action("bottom text") );
	menu->insert( m_privateActionCollection->action("right text") );
	menu->insert( m_privateActionCollection->action("separator") );
	menu->insert( m_privateActionCollection->action("left to right") );
	menu->insert( m_privateActionCollection->action("top to bottom") );
	menu->insert( m_privateActionCollection->action("separator") );
	menu->insert( m_privateActionCollection->action("wordwrap text") );
}
//-----------------------------------------------
void KBearIconView::readConfig( KConfig* config, const QString& group ) {
	// Have to do this in order to have LargeRows as default
	KConfigGroupSaver cs( config, group );
	QString mode = config->readEntry("ViewMode", QString::fromLatin1("LargeRows") );
	config->writeEntry("ViewMode", mode );
	KFileDnDIconView::readConfig( config, group );
}
//-----------------------------------------------
void KBearIconView::writeConfig( KConfig* config, const QString& group ) {
	KFileDnDIconView::writeConfig( config, group );
}
//-----------------------------------------------
void KBearIconView::rename(){
	QIconViewItem* item = currentItem();
	KFileIconViewItem* viewItem = 0L;
	if( ! ( viewItem = dynamic_cast<KFileIconViewItem*>( item ) ) )
		return;

	viewItem->rename();
}
//-----------------------------------------------
void KBearIconView::slotItemRenamed( QIconViewItem* it, const QString& newName ) {
	KFileIconViewItem* item = dynamic_cast<KFileIconViewItem*>( it );
	if( ! item )
		return;

	KFileItem* fileItem = item->fileInfo();
	KURL oldURL = fileItem->url();
	KURL newURL = oldURL;
	newURL.adjustPath( -1 );
	newURL.setFileName( newName );
	if( oldURL == newURL )
		return;

	fileItem->setURL( newURL );

	emit rename( oldURL, newURL );
}
//-----------------------------------------------
void KBearIconView::setItemTextPos( QIconView::ItemTextPos ) {
	if( static_cast<KToggleAction*>(m_privateActionCollection->action("bottom text"))->isChecked() )
		QIconView::setItemTextPos( QIconView::Bottom );
	else
		QIconView::setItemTextPos( QIconView::Right );
}
//-----------------------------------------------
void KBearIconView::setArrangement( QIconView::Arrangement ) {
	if( static_cast<KToggleAction*>(m_privateActionCollection->action("left to right"))->isChecked() )
		QIconView::setArrangement( QIconView::LeftToRight );
	else
		QIconView::setArrangement( QIconView::TopToBottom );
}
//-----------------------------------------------
void KBearIconView::setWordWrapIconText( bool ) {
	if( static_cast<KToggleAction*>(m_privateActionCollection->action("wordwrap text"))->isChecked() )
		QIconView::setWordWrapIconText( true );
	else	
		QIconView::setWordWrapIconText( false );
}
//-----------------------------------------------
void KBearIconView::slotTextBottom(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("bottom text"));
	action->setChecked( true );
	setItemTextPos( QIconView::Bottom );
}
//-----------------------------------------------
void KBearIconView::slotTextRight(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("right text"));
	action->setChecked( true );
	setItemTextPos( QIconView::Right );
}
//-----------------------------------------------
void KBearIconView::slotFlowEast(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("left to right"));
	action->setChecked( true );
	setHScrollBarMode( QIconView::AlwaysOff );
	setVScrollBarMode( QIconView::Auto );
	setArrangement( QIconView::LeftToRight );
}
//-----------------------------------------------
void KBearIconView::slotFlowSouth(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("top to bottom"));
	action->setChecked( true );
	setVScrollBarMode( QIconView::AlwaysOff );
	setHScrollBarMode( QIconView::Auto );
	setArrangement( QIconView::TopToBottom );
}
//-----------------------------------------------
void KBearIconView::slotTextWordWrap( bool wrap ){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("wordwrap text"));
	action->setChecked( wrap );
	setWordWrapIconText( wrap );
}
//-----------------------------------------------

