/*********************************************************************************
* C++ Implementation: kbeariconview.h
* Description:
*                              
* Begin : ons feb 26 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


#ifndef KBEARKBEARICONVIEW_H
#define KBEARKBEARICONVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kfiledndiconview.h"
#include "kbearfileviewinterface.h"
#include "siteinfo.h"

class KActionCollection;

namespace KBear {
	/**
	*
	* Bjrn Sahlstrm
	**/
	class KBearIconView : public KFileDnDIconView, virtual public KBearFileViewInterface {
		Q_OBJECT
	public:
		/** */
		KBearIconView(QWidget *parent, const char *name, const SiteInfo& c);
		/** */
		~KBearIconView();
		/** */
		virtual void setItemTextPos( QIconView::ItemTextPos pos );
		/** */
		virtual void setArrangement( QIconView::Arrangement am );
		/** */
		virtual void setWordWrapIconText( bool b );
		/** */
		virtual void readConfig( KConfig*, const QString& group = QString::null );
		/** */
		virtual void writeConfig( KConfig*, const QString& group = QString::null );
		/** */
		virtual void rename();
	signals:
		/** */
		void rename( const KURL& oldURL, const KURL& newURL );
	protected slots: // private slots
		/** */
		void slotItemRenamed( QIconViewItem*, const QString& );
	protected:
		/**
		* Create dragobject encoding the current selection and starts the drag
		*/
		virtual void startDrag();
	private slots: // private slots
		void slotTextRight();
		void slotTextBottom();
		void slotFlowSouth();
		void slotFlowEast();
		void slotTextWordWrap( bool );
	private: // Private methods
		void setupActions();
	private:
		KActionCollection* m_privateActionCollection;
		SiteInfo m_siteInfo;
	};

}
#endif
