/***************************************************************************
                          kbeartabview.cpp  -  description
                             -------------------
    begin                : sn feb 10 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
/////////////////////////////////////////////////////
// KDE specific includes
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartabview.h"

#include "kbeartabview.moc"

using namespace KBear;
//-----------------------------------------------
class KBearTabViewPrivate {
	public:
};
//-----------------------------------------------
KBearTabView::KBearTabView(QWidget *parent, const char *name )
	:	KDockTabGroup(parent,name),
		m_shouldBeVisible( true )
{
	m_tabs.setAutoDelete( true );
}
//-----------------------------------------------
KBearTabView::~KBearTabView(){
}
//-----------------------------------------------
void KBearTabView::youShouldBeVisible( bool b ) {
	bool showMe = true;
	m_shouldBeVisible = b;
	if( m_shouldBeVisible ) {
		if( count() <= 0 )
			showMe = false;
	}
	else if( ! m_shouldBeVisible ){	
		showMe = false;
	}
	if( showMe ) {
		show();
		emit imShowing();
	}
	else {
		hide();
		emit imHiding();
	}
}
//-----------------------------------------------
void KBearTabView::addPage( int ID, QWidget* w, const QString& name ){
	kdDebug()<<"KBearTabView::addPage ID="<<ID<<" widget="<<w<<endl; 
	m_tabs.insert( ID, w );
	addTab( w, name );
	showPage( w );

	if( m_shouldBeVisible && isHidden() ) {
		show();
		emit imShowing();
	}
}
//-----------------------------------------------
void KBearTabView::removePage( int ID ){
	kdDebug()<<"KBearTabView::removePage ID="<<ID<<endl; 
	QWidget* w = m_tabs.find( ID );
/*
	if( ! w );
		return;
*/	
	kdDebug()<<"KBearTabView::removePage widget="<<w<<endl; 
	QTabWidget::removePage( w );
	m_tabs.remove( ID ); // this will also delete the widget
	
	if( count() <= 0 ) {
		hide();
		emit imHiding();
	}
}
//-----------------------------------------------
