/***************************************************************************
                          kbeartextedit.h  -  description
                             -------------------
    begin                : Fri Apr 12 2002
    copyright            : (C) 2002, 2003 by Peter Svrd and Bjrn Sahlstrm
    email                : tocool@users.sourceforge.net, kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARTEXTEDIT_H
#define KBEARTEXTEDIT_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qtextedit.h>
//////////////////////////////////////////////////////
// KDE specific includes

//////////////////////////////////////////////////////
// Application specific includes

//////////////////////////////////////////////////////

class QTextCodec;
class QPopupMenu;

/**
* @author Peter Swrd
*/

namespace KBear {
	class KBearTextEdit : public QTextEdit {
		Q_OBJECT
	public:
		/** No descriptions */
		KBearTextEdit(QWidget* parent=0, const QString& name=0);
		/** No descriptions */
		virtual ~KBearTextEdit();
		/** No descriptions */
		void setEncoding( const QString& encoding );
	public slots:
		/** No descriptions */
		void slotSaveAs();
		/** Uses the encoding set by @see #setEncoding to encode the string before appending it. */
		virtual void append( const QString& text );
	protected:
		/** Reimplemented from @ref QTextEdit, just to be able to add some extra functions to the popupmenu. */
		virtual QPopupMenu* createPopupMenu( const QPoint& pos );
	private:
		QTextCodec* m_codec;
		QPopupMenu* m_popUp;
		class KBearTextEditPrivate;
		KBearTextEditPrivate* d;
	};
};

#endif
