/***************************************************************************
                          kbeartreeview.cpp  -  description
                             -------------------
    begin                : sn feb 10 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdragobject.h>
#include <qapplication.h>
#include <qstyle.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartreeview.h"

#ifndef AUTO_OPEN_TIME
#define AUTO_OPEN_TIME
	static int autoOpenTime = 750;
#endif



#include "kbeartreeview.moc"

using namespace KBear;
//-----------------------------------------------
class KBearTreeViewPrivate {
	public:
};
//-----------------------------------------------
KBearTreeView::KBearTreeView(QWidget *parent, const char *name )
	:	KListView(parent,name), m_dropItem( 0L ),
		m_currentBeforeDropItem( 0L ), m_autoOpenTimer(this)
{
	addColumn( i18n("Name") );
	setTooltipColumn( 0 );
	setRootIsDecorated( true );
	setShowSortIndicator( true );
	setFullWidth( false );
	setSelectionModeExt( KListView::Single );
	setDNDEnabled();
//	setHScrollBarMode( AlwaysOn );
	setFocusPolicy( QWidget::WheelFocus );
	connect( &m_autoOpenTimer, SIGNAL( timeout() ), this, SLOT( slotOpenFolder() ) );
	connect( this, SIGNAL( executed( QListViewItem* ) ), this, SLOT( slotExecuted( QListViewItem*) ) );
}
//-----------------------------------------------
KBearTreeView::~KBearTreeView(){
}
//-----------------------------------------------
void KBearTreeView::slotExecuted( QListViewItem* item ) {
	kdDebug()<<"KBearTreeView::slotExecuted()"<<endl;
	if( ! item || ! item->isExpandable() )
		return;
	ensureItemVisible( item );
	setCurrentItem( item );
	setSelected( item, true );
	item->setOpen( ! item->isOpen() );
}
//-----------------------------------------------
void KBearTreeView::contentsDragEnterEvent( QDragEnterEvent *e ) {
	if ( ! acceptDrag( e ) ) {
		e->accept( false );
		return;
	}
	e->acceptAction();
	m_currentBeforeDropItem = selectedItem();
	QListViewItem* item = itemAt( contentsToViewport( e->pos() ) );
	if( item ) {
		m_dropItem = item; // set m_dropItem
		m_autoOpenTimer.start( autoOpenTime );  // start timer
	}
	else {
		m_dropItem = 0L;
	}
}
//-----------------------------------------------
void KBearTreeView::contentsDragMoveEvent( QDragMoveEvent *e ) {
	if ( ! acceptDrag( e ) ) {
		e->accept( false );
		return;
	}
	e->acceptAction();
	QListViewItem* item; 
	QListViewItem *par;

   findDrop( e->pos(), par, item );
//	QListViewItem* item = itemAt( contentsToViewport(  e->pos() ) );
	if ( item && item->isSelectable() ) {
		setSelected( item, true );
		if( item != m_dropItem ) { // if this item isn't the same as m_dropItem
			m_autoOpenTimer.stop(); // stop timer
			m_dropItem = item; // set m_dropItem
			m_autoOpenTimer.start( autoOpenTime ); // start timer
		}
	}
	else {
/*
		if( selectedItem() )
			setSelected( selectedItem(), false );
*/
		m_autoOpenTimer.stop();
		m_dropItem = 0L;
	}
}
//-----------------------------------------------
void KBearTreeView::contentsDragLeaveEvent( QDragLeaveEvent* ) {
	if( m_currentBeforeDropItem ) {
		setSelected( m_currentBeforeDropItem, true );
		ensureItemVisible( m_currentBeforeDropItem );
	}
	else
		setSelected( m_dropItem, false ); // no item selected

	m_autoOpenTimer.stop();  // stop timer
	m_dropItem = 0L;  // reset m_dropItem
}
//-----------------------------------------------
void KBearTreeView::contentsDropEvent( QDropEvent* e ) {
	m_autoOpenTimer.stop();  // stop timer
	m_dropItem = 0; // reset m_dropItem
	if( ! acceptDrag( e ) ) {
		e->acceptAction( false );
		return;
	}
	e->acceptAction();				
	QListViewItem *afterme;
	QListViewItem *parent;
	findDrop(e->pos(), parent, afterme);
	emit dropped( e );
	emit dropped( this, e );
	emit KListView::dropped( e, afterme );
	emit dropped( this, e, afterme );
	emit KListView::dropped( e, parent, afterme );
	emit dropped( this, e, parent, afterme );
}
//-----------------------------------------------
void KBearTreeView::slotOpenFolder(){
	m_autoOpenTimer.stop(); // stop timer
	if( m_dropItem /*&& ! m_dropItem->isOpen() */&& m_dropItem->isExpandable() ) {   // if we have a m_dropItem
		emit executed( m_dropItem ); // open it
	}
}
//-----------------------------------------------
QListViewItem* KBearTreeView::findItemByName( const QListViewItem* parent, const QString& name ){
	QListViewItemIterator it( this );
	for ( ; it.current(); ++it ) {
		if ( it.current()->parent() == parent && it.current()->text( 0 ) == name )
			return it.current();
	}
	return 0L;	
}
//-----------------------------------------------
QListViewItem* KBearTreeView::findParentByFullName( const QString& name ){
	if( name.isEmpty() )
		return 0L;
	QStringList nameList = QStringList::split( "/", name );
	QListViewItem* parent = 0L;
	QListViewItem* item = 0L;
	for( QStringList::Iterator iter = nameList.begin(); iter != nameList.end(); ++iter ) {
		item = findItemByName( parent, *iter );
		if( item )
			parent = item;
		else
			return parent;
	}
	return parent;	
}
//-----------------------------------------------
void KBearTreeView::setDNDEnabled( bool enable ){
	setDragEnabled( enable );
	setDropVisualizer( enable );
	setAcceptDrops( enable );
	viewport()->setAcceptDrops( enable );
}
//-----------------------------------------------
