//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kaboutdata.h>
#include <dcopclient.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kdesktopfile.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearmainwindow.h"
#include "kbearsplash.h"
#include "pluginmanager.h"
#include "kbearcore.h"
#include "api.h"
#include "resource.h"

static KCmdLineOptions options[] = {
		{ "+[url] [url]....", I18N_NOOP("The url/urls to open"), 0 },
		{ 0, 0, 0 }
};

int main(int argc, char **argv) {

	KAboutData aboutData( PACKAGE, I18N_NOOP("KBear"), QString::number( IDS_VERSION ).latin1(),
								I18N_NOOP("KBear is a graphical FTP client for KDE."), KAboutData::License_GPL,
								IDS_COPYRIGHT.latin1(), 0, IDS_HOMEPAGE.latin1(), "kbjorn@users.sourceforge.net" );
	aboutData.addAuthor( "Björn Sahlström", I18N_NOOP("Maintainer and main developer"), "kbjorn@users.sourceforge.net" );
	aboutData.addAuthor( "Frithjof Engel", I18N_NOOP("Developer"), "frithjof_engel@users.sourceforge.net" );
	aboutData.addAuthor( "Peter Svärd", I18N_NOOP("Developer"), "tocool@telia.com" );
	aboutData.addCredit( "Falk Brettschneider", I18N_NOOP("For implementing the excellent library KMdi"),
									"gigafalk@yahoo.com", "http://www.geocities.com/gigafalk/qextmdi.htm" );
	aboutData.addCredit( "Carsten Pfeiffer" , I18N_NOOP("For tips and encourage"), "pfeiffer@kde.org" );
	aboutData.addCredit( "Waldo Bastian", I18N_NOOP("For help and tips"), "bastian@kde.org" );
	aboutData.addCredit( "Rinse de Vries", I18N_NOOP("Dutch GUI translation"), "rinse@kde.nl" );
	aboutData.addCredit( "Jan De Luyck", I18N_NOOP("Dutch DOC translation"), "devilkin@users.sourceforge.net" );
	aboutData.addCredit( "Fred Lessing", I18N_NOOP("European Portuguese GUI translation"), "acento22@mail.telepac.pt" );
	aboutData.addCredit( "Matěj Hausenblas", I18N_NOOP("Czech GUI and DOC translation"), "matejh@users.sourceforge.net" );
	aboutData.addCredit( "CAULIER Gilles", I18N_NOOP("French GUI and DOC translation"), "caulier.gilles@free.fr" );
	aboutData.addCredit( "Eugene Doubravsky", I18N_NOOP("Russian GUI translation"), "johnny@mailru.com" );
	aboutData.addCredit( "Frithjof Engel", I18N_NOOP("German GUI translation"), "frithjof_engel@users.sourceforge.net" );
	aboutData.addCredit( "Aviv Rosental", I18N_NOOP("Hebrew GUI translation"), "aviv@fireball.org.il" );
	aboutData.addCredit( "Muhammad Panji", I18N_NOOP("Indonesian GUI translation"), "sumodirjo@yahoo.co.uk" );
	aboutData.addCredit( "Giovanni Venturi", I18N_NOOP("Italian GUI and DOC translation"), "jumpyj@libero.it" );
	aboutData.addCredit( "Alexandru Deac", I18N_NOOP("Romanian GUI translation"), "alex.deac@shaw.ca" );
	aboutData.addCredit( "Vicentiu Maxim", I18N_NOOP("Romanian DOC translation"), "max@css.sintec.ro" );
	aboutData.addCredit( "Björn Sahlström", I18N_NOOP("Swedish GUI and DOC translation"), "kbjorn@users.sourceforge.net" );
	aboutData.addCredit( "張建邦<CHANG CHIEN-PANG>", I18N_NOOP("Chinese GUI and DOC translation"), "denelge@seed.net.tw" );
	aboutData.addCredit( "Ignacio Verona", I18N_NOOP("Espanol DOC translation"), "nacho@davidliz.dyndns.org" );
	
	
	KCmdLineArgs::init(argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions(options);
	KApplication::addCmdLineOptions();

	KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

	KApplication app;
	KBearSplash* splash = new KBearSplash();
	app.processEvents();

	QObject::connect( API::getInstance()->pluginManager(), SIGNAL( loadingPlugin( const QString& ) ),
					splash, SLOT( slotShowMessage( const QString& ) ) );
	API::getInstance()->pluginManager()->loadPlugins();
	app.processEvents();

	//	splash->raise();

	KURL url;
	for(int i=0; i<args->count(); i++) {
		if( KDesktopFile::isDesktopFile( args->arg( i ) ) ) {
			KDesktopFile desktopFile( args->arg( i ) );
			url = desktopFile.readURL();
		}
		else
			url = args->url( i );
		API::getInstance()->mainWindow()->openURL( url.url() );
	}

	args->clear();  // release memory
	
	app.processEvents();
	delete splash;
	API::getInstance()->core()->emitInitialized();
	API::getInstance()->mainWindow()->readProperties( kapp->config() );
	return app.exec();
}
