/*********************************************************************************
* C++ Interface: kbearlocaldirlister.h
* Description:
*                              
* Begin : lr feb 16 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARLOCALDIRLISTER_H
#define KBEARLOCALDIRLISTER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardirlisteriface.h"

class KDirLister;
/**
 * 
 * Bjrn Sahlstrm
 **/
class KBearLocalDirLister : public KBear::KBearDirListerIface {
	Q_OBJECT
public:
	/** */
	KBearLocalDirLister( QWidget* parent );
	/** */
	virtual bool isLocal() const { return true; }
	/** */
	~KBearLocalDirLister();
	/** */
	virtual void openConnection();
	/** */
	virtual void openURL( const KURL& url, bool reload = false );
	/** */
	virtual void statURL( const KURL& url, bool statingLink = false );
	/** */
	virtual void getMimetype( const KURL& url );
	/** */
	virtual void setShowingDotFiles( bool );
	/** */
	virtual void stop();
	/** */
	virtual void mkdir( const KURL& newDir );
	/** */
	virtual void deleteFiles( const KURL::List urls, bool shred, bool showProgress );
	/** */
	virtual void setNameFilter(const QString& filter);
	/** */
	virtual bool showingDotFiles() const;
public slots:
	/** */
	virtual void slotRename( const KURL& oldURL, const KURL& newURL );
private:
	KDirLister* m_dirLister;
};

#endif
