/*********************************************************************************
* C++ Implementation: kbearremotefilesyspart.cpp
* Description:
*                              
* Begin : lr feb 09 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstringlist.h>
#include <qlabel.h>
#include <qvaluelist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/genericfactory.h>
#include <kparts/partmanager.h>
#include <kio/job.h>
#include <kservice.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <kapplication.h>
#include <krun.h>
#include <klocale.h>
#include <kfileview.h>
#include <kfileitem.h>
#include <kinstance.h>
#include <kmainwindow.h>
#include <kstatusbar.h>

#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearremotefilesyspart.h"
#include "kbearpropertiesdialog.h"
#include "kbeardirlisteriface.h"
#include "kbearfilesyswidget.h"
#include "siteinfo.h"
#include "kbearapi.h"
#include "kbearcore.h"
#include "kbearapi.h"
#include "kbeardirview.h"
#include "kbearremotedirlister.h"
#include "kbeardetailview.h"
#include "kbeariconview.h"



#include "kbearremotefilesyspart.moc"

using namespace KBear;
//-----------------------------------------------
typedef KParts::GenericFactory<KBearRemoteFileSysPart> KBearRemoteFileSysPartFactory;
K_EXPORT_COMPONENT_FACTORY( libkbearremotefilesyspart, KBearRemoteFileSysPartFactory );
//-----------------------------------------------
KBearRemoteFileSysPart::KBearRemoteFileSysPart( QWidget* parentWidget, const char* widgetName, QObject* parent, const char* name, const QStringList& )
	:	KBearFileSysPartInterface( parentWidget, widgetName, parent, name )

{
	// we need an instance
	setInstance( KBearRemoteFileSysPartFactory::instance() );
	KGlobal::locale()->insertCatalogue("kbear");
	
//	setXMLFile("kbearremotefilesyspart.rc");

	m_myWidget->setDirLister( new KBearRemoteDirLister( m_myWidget ) );
}
//-----------------------------------------------
KBearRemoteFileSysPart::~KBearRemoteFileSysPart() {
}
//-----------------------------------------------
void KBearRemoteFileSysPart::slotProperties() {
	if( m_myWidget->fileView() ) {
		KFileItemList* items = (KFileItemList*)selectedItems();
		if( items->isEmpty() )
			return;

		KBearPropertiesDialog dlg( (int)dirLister()->siteInfo().ID(), *items, m_myWidget, "propdialog" );
		connect( &dlg, SIGNAL( applied() ), this, SLOT( reload() ) );

		dlg.exec();
	}
}
//-----------------------------------------------
KAboutData* KBearRemoteFileSysPart::createAboutData() {
	KAboutData* about = new KAboutData( "kbearremotefilesyspart", I18N_NOOP("KBearRemoteFileSysPart"), "1.0", 0,
							KAboutData::License_GPL, I18N_NOOP("(C) 2003, The KBear team") );
	about->addAuthor("Björn Sahlström", 0, "kbjorn@users.sourceforge.net");

	return about;
}
//-----------------------------------------------
void KBearRemoteFileSysPart::openWith( const KURL::List& urlList ) {
	if( ! KRun::displayOpenWithDialog( urlList, false ) ) { // user canceled
		KIO::SimpleJob::removeOnHold();
	}
}
//-----------------------------------------------
void KBearRemoteFileSysPart::executeService( const QString& exec, const KURL::List& urlList, const QString& name, const QString& icon ) {
	// TODO: check if this needs to be changed
	KRun::run( exec, urlList, name, icon );
}
//-----------------------------------------------
KBearDirView* KBearRemoteFileSysPart::createTreeView( QWidget* parent, const SiteInfo& info ) {
	KBearDirView* view = new KBearDirView( parent, "DirView", info );
	connect( view, SIGNAL(dropped( QMimeSource*, const QPoint& )),
				this,SLOT( slotDropped(QMimeSource*, const QPoint&)));
	return view;
}
//-----------------------------------------------
KFileView* KBearRemoteFileSysPart::createView( QWidget* parent, KFile::FileView view ) {
	m_viewActionCollection = 0;
	KFileView* newView = 0L;
	if((view & KFile::Simple) == KFile::Simple ) {
		newView = new KBearIconView( parent, "simple view", m_siteInfo);
		connect( static_cast<KBearIconView*>(newView), SIGNAL(dropped( QMimeSource*, const QPoint& )),
					this,SLOT( slotDropped(QMimeSource*, const QPoint&)));
		connect( static_cast<KBearIconView*>(newView), SIGNAL(selectionChanged()),
					this,SLOT(slotSelectionChanged()));
		connect( static_cast<KBearIconView*>(newView), SIGNAL(rename( const KURL&, const KURL& )),
					m_myWidget->dirLister(),SLOT(slotRename( const KURL&, const KURL& )));
	}
	else {
		newView = new KBearDetailView( parent, "detail view", m_siteInfo);
		connect( static_cast<KBearDetailView*>(newView), SIGNAL(dropped( QMimeSource*, const QPoint& )),
					this,SLOT( slotDropped(QMimeSource*, const QPoint&)));
		connect( static_cast<KBearDetailView*>(newView), SIGNAL(selectionChanged()),
					this,SLOT(slotSelectionChanged()));
		connect( static_cast<KBearDetailView*>(newView), SIGNAL(rename( const KURL&, const KURL& )),
					m_myWidget->dirLister(),SLOT(slotRename( const KURL&, const KURL& )));
	}
	newView->widget()->hide();
	return newView;
}
//-----------------------------------------------
