/*********************************************************************************
* C++ Interface: kbearremotefilesyspart.h
* Description:
*                              
* Begin : lr feb 09 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARREMOTEFILESYSPART_H
#define KBEARREMOTEFILESYSPART_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrstack.h>
#include <qvaluelist.h>
#include <qptrlist.h>
#include <qdatetime.h>
#include <qpoint.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kaction.h>
#include <kparts/event.h>
#include <kaboutdata.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearfilesyspartiface.h"
#include "siteinfo.h"

class KBearRemoteDirLister;

/**
	*
	* @author Bjrn Sahlstrm
	**/
class KBearRemoteFileSysPart : public KBear::KBearFileSysPartInterface {
	Q_OBJECT
public:
		/** */
	KBearRemoteFileSysPart( QWidget* parentWidget, const char* widgetName, QObject* parent, const char* name, const QStringList& = QStringList() );
		/** */
	~KBearRemoteFileSysPart();
	/** */
	static KAboutData* createAboutData();
	/**
	* @return if the part works against a local file system.
	*/
	virtual bool isLocal() const { return false; };
	/** */
	virtual QString fromUnicode( const QString& str ) { return str; }
	/** */
	virtual QString toUnicode( const QString& str ) { return str; }
	/** No descriptions */
	virtual void openWith( const KURL::List& );
protected slots:
	/** */
	virtual void slotProperties();
protected:
	/** No descriptions */
	virtual void executeService( const QString& exec, const KURL::List& urlList, const QString& name, const QString& icon );
	/**
	* A view factory for creating predefined fileviews.
	*/
	virtual KBear::KBearDirView* createTreeView( QWidget* parent, const KBear::SiteInfo& info );
	/**
	* A view factory for creating predefined fileviews.
	*/
	virtual KFileView* createView( QWidget* parent, KFile::FileView view );
protected:
	KBearRemoteDirLister* m_dirLister;
};

#endif
