/*********************************************************************************
* C++ Implementation: filediffdropwidget.cpp
* Description:
*
* Begin : ons jun 18 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qfont.h>
#include <qsizepolicy.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kurl.h>
#include <klocale.h>
#include <kurldrag.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "filediffdropwidget.h"


#include "filediffdropwidget.moc"
//-----------------------------------------------
FileDiffDropWidget::FileDiffDropWidget( const QString& text, Type type, QWidget *parent, const char *name )
	:	KSqueezedTextLabel( parent, name ), m_type( type ), m_text( text )
{
	setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding ) );
	setAcceptDrops( true );
	setAlignment( AlignHCenter | AlignVCenter );
	setText( QString("<h2>%1</h2>").arg( m_text ) );
}
//-----------------------------------------------
FileDiffDropWidget::~FileDiffDropWidget() {
}
//-----------------------------------------------
void FileDiffDropWidget::clear() {
	m_file = QString::null;
	setText( QString("<h2>%1</h2>").arg( m_text ) );
}
//-----------------------------------------------
void FileDiffDropWidget::setFileName( const QString& file ) {
	if( file.isEmpty() )
		return;

	m_file = file;
	if( m_type == Source ) {
			setText( i18n("Source file:\n%1").arg( m_file ) );
	}
	else {
			setText( i18n("Destination file:\n%1").arg( m_file ) );
	}
}
//-----------------------------------------------
void FileDiffDropWidget::slotProgress( long, unsigned long progress ) {
	if( m_type == Source ) {
		setText( i18n("Retrieving source file:\n%1\n%2 %").arg( m_file ).arg( QString::number( progress ) ) );
	}
	else {
		setText( i18n("Retrieving destination file:\n%1\n%2 %").arg( m_file ).arg( QString::number( progress ) ) );
	}
}
//-----------------------------------------------
void FileDiffDropWidget::dragMoveEvent( QDragMoveEvent *e ) {
	if ( ! acceptDrag( e ) ) {
		e->accept( false );
		return;
	}
	e->acceptAction();
}
//-----------------------------------------------
void FileDiffDropWidget::dropEvent( QDropEvent* e ) {
	if( ! acceptDrag( e ) ) {
		e->acceptAction( false );
		return;
	}
	e->acceptAction();

	emit dropped( e );
}
//-----------------------------------------------
bool FileDiffDropWidget::acceptDrag(QDropEvent* e ) const {
	return KURLDrag::canDecode( e );
}
//-----------------------------------------------


