/*********************************************************************************
* C++ Implementation: kbeardifftextedit.cpp
* Description:
*
* Begin : sn jun 22 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpopupmenu.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardifftextedit.h"


#include "kbeardifftextedit.moc"
//-----------------------------------------------
KBearDiffTextEdit::KBearDiffTextEdit( QWidget* parent, const char* name )
	:	QTextEdit( parent, name )
{
	setReadOnly( true );
	setTextFormat( PlainText );
}
//-----------------------------------------------
KBearDiffTextEdit::~KBearDiffTextEdit() {
}
//-----------------------------------------------
void KBearDiffTextEdit::setEnableHighlight( bool highlight ) {
	static QColor cAdded( 190, 190, 237);
	static QColor cRemoved( 190, 237, 190 );
	if( highlight ) {
		int paragCount = paragraphs();
		for( int i = 0; i < paragCount; ++i ) {
			QString txt = text( i );
			if( txt.length() > 0 ) {
				if( txt.startsWith( "+" ) || txt.startsWith( ">" ) ) {
					setParagraphBackgroundColor( i, cAdded );
				}
				else if( txt.startsWith( "-" ) || txt.startsWith( "<" ) ) {
					setParagraphBackgroundColor( i, cRemoved );
				}
			}
		}
	}
	else {
		int paragCount = paragraphs();
		for( int i = 0; i < paragCount; ++i ) {
			clearParagraphBackground( i );
		}
	}
}
//-----------------------------------------------
QPopupMenu* KBearDiffTextEdit::createPopupMenu() {
	return createPopupMenu( QPoint() );
}
//-----------------------------------------------
QPopupMenu* KBearDiffTextEdit::createPopupMenu( const QPoint& p ) {
	QPopupMenu* menu = QTextEdit::createPopupMenu( p );
	if( ! menu )
		menu = new QPopupMenu( this );

	emit popupMenuRequest( menu );

	return menu;
}
//-----------------------------------------------


