/*********************************************************************************
* C++ Interface: firewallsettingswidget.h
* Description:
*                              
* Begin : lr jan 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef FIREWALLSETTINGSWIDGET_H
#define FIREWALLSETTINGSWIDGET_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
//////////////////////////////////////////////////////
// KDE specific includes
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearconfigwidgetiface.h"

class KComboBox;
class KIntSpinBox;
class QLabel;
class KLineEdit;
class QTextEdit;
class KConfig;

/**
  *@author Bjrn Sahlstrm
  */

class FirewallSettingsWidget : public KBear::KBearConfigWidgetIface  {
   Q_OBJECT
public: 
	/** */
	FirewallSettingsWidget( KConfig* config, QWidget *parent=0, const char *name=0);
	/** */
	~FirewallSettingsWidget();
	/** */
	enum {
		NONE=0,
		TYPE_ONE=1,
		TYPE_TWO=2,
		TYPE_THREE=3,
		TYPE_FOUR=4,
		TYPE_FIVE=5,
		TYPE_SIX=6,
		TYPE_SEVEN=7,
		TYPE_EIGHT=8
	}FirewallType;
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual QString helpSection() const { return QString::fromLatin1("firewall-settings"); }
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual bool helpEnabled() const { return true; }
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void saveSettings();
	/** 
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void readSettings( bool defaultSettings = false );
public slots:
	/** */
	void slotSaveSettings() { saveSettings(); }
private slots:
	void slotFirewallTypeActivated( int type );
private:
	void setupGUI();
private:
	const QString m_type0Str;
	const QString m_type1Str;
	const QString m_type2Str;
	const QString m_type3Str;
	const QString m_type4Str;
	const QString m_type5Str;
	const QString m_type6Str;
	const QString m_type7Str;
	const QString m_type8Str;
	QTextEdit* m_firewallSpecialText;
	KLineEdit* m_firewallHostEdit;
	KLineEdit* m_firewallAccountEdit;
	KIntSpinBox* m_firewallPortSpinBox;
	KComboBox* m_firewallTypeCombo;
	KLineEdit* m_firewallPassEdit;
	KLineEdit* m_firewallUserEdit;
	QLabel* m_firewallHostLabel;
	QLabel* m_firewallAccountLabel;
	QLabel* m_firewallPortLabel;
	QLabel* m_firewallTypeLabel;
	QLabel* m_firewallPassLabel;
	QLabel* m_firewallUserLabel;
	KConfig* m_config;
};

#endif
