/*********************************************************************************
* C++ Interface: urllistimportfilterplugin.h
* Description:
*
* Begin : Tue May 27 2003
* Author : Frithjof Engel <frithjof_engel@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBearImportFilterPlugin_H
#define KBearImportFilterPlugin_H

//////////////////////////////////////////////////////
// Qt specific includes
//////////////////////////////////////////////////////
// KDE specific includes
#include <kurl.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearsiteimportfilterpluginiface.h"

struct UrlListImportConnectInfo;
/**
  *@author Frithjof Engel
  */

class UrlListImportFilterPlugin : public KBear::SiteImportFilterPluginIface  {
   Q_OBJECT
public:
	/** */
	UrlListImportFilterPlugin(QObject *parent=0, const char *name=0, const QStringList &args = QStringList());
	/** */
	~UrlListImportFilterPlugin();
	/**
	* This function should return a @ref QDomDocument containing the imported bookmarks.
	* @return the @ref QDomDocument s @ref QString representation containing the imported bookmarks.
	*/
	virtual QString getDomDocument();
	/**
	* Function should start the import
	* @param fileName is the full path to the file to import
	*/
	virtual void import( const QString& fileName );

	virtual bool hasError() const { return m_hasError; }
private:
 	bool addSite( UrlListImportConnectInfo Inf );
private:
	QDomDocument m_domDocument;
	bool m_hasError;
};

#endif
