/***************************************************************************
                          wincommanderimportfilterplugin.h  -  description
                             -------------------
    begin                : tis mar 19 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WinCommanderImportFilterPlugin_H
#define WinCommanderImportFilterPlugin_H

//////////////////////////////////////////////////////
// Qt specific includes
//////////////////////////////////////////////////////
// KDE specific includes
#include <kurl.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearsiteimportfilterpluginiface.h"

class QDomDocument;
/**
  *@author Bjrn Sahlstrm
  */

class WinCommanderImportFilterPlugin : public KBear::SiteImportFilterPluginIface  {
   Q_OBJECT
public:
	/** */
	WinCommanderImportFilterPlugin(QObject *parent=0, const char *name=0, const QStringList &args = QStringList());
	/** */
	~WinCommanderImportFilterPlugin();
	/**
	* This function should return a @ref QDomDocument containing the imported bookmarks.
	* The document should have the format:
	* <pre>
	*	group label="APPNAME-imports"
	*		group label="group1"
	*			site label="site1"
	*			............	
	*			/site
	*			.................
	*		/group
	*		...................
	*	/group
	*	..................
	*</pre>
	* @return the @ref QDomDocument s @ref QString representation containing the imported bookmarks.
	*/
	virtual QString getDomDocument();	
	/**
	* Function should start the import
	* @param fileName is the full path to the file to import
	*/
	virtual void import( const QString& fileName );
	/**
	* This function is used by the caller to find out wether or not
	* the import waas successfull. If anything went wrong during
	* import this function should return true.
	* This stop update of databse.
	* @return false om succes or true on error.
	*/
	virtual bool hasError() const { return m_hasError; }
private:
	void invalidFileError(const QString& fileNam);
private:
	QDomDocument m_domDocument;
	bool m_hasError;
};

#endif
