/***************************************************************************
                          ws_ftpimportfilterplugin.cpp  -  description
                             -------------------
    begin                : tis mar 19 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qdom.h>
#include <qdir.h>
#include <qstringlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kconfig.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "ws_ftpimportfilterplugin.h"
#include "kbeartags.h"
#include "misc.h"

#include "ws_ftpimportfilterplugin.moc"

using namespace KBear;

typedef KGenericFactory<WS_FTPImportFilterPlugin> WS_FTPImportFilterPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearwsftpimportfilter, WS_FTPImportFilterPluginFactory( "WS_FTPImportFilterPlugin" ) );
//-----------------------------------------------
WS_FTPImportFilterPlugin::WS_FTPImportFilterPlugin(QObject *parent, const char *name,const QStringList& )
	:	SiteImportFilterPluginIface(parent,name),
		m_hasError( false )
{
//	setXMLFile("ws_ftpimportfilterui.rc");
	KGlobal::locale()->insertCatalogue( QString::fromLatin1("kbear") );
	m_domDocument.setContent( QString("<%1 %2=\"%3\"/>").arg(TAG_GROUP).arg(ATT_LABEL).arg(i18n("WS_FTP import (Win)")) );
}
//-----------------------------------------------
WS_FTPImportFilterPlugin::~WS_FTPImportFilterPlugin(){
}
//-----------------------------------------------
QString WS_FTPImportFilterPlugin::getDomDocument() {
	return m_domDocument.toString();
}
//-----------------------------------------------
void WS_FTPImportFilterPlugin::import( const QString& fileName ) {
	if( fileName.isEmpty() || fileName.isNull() ) {
		KMessageBox::sorry( 0, i18n("You have to select a file to import."), i18n("No file") );
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	int answer = KMessageBox::warningContinueCancel( 0,
					i18n("Currently this import filter can't import the passwords in this file.\n"
							"Because of this you have retype the passwords before using the bookmark."), i18n("Password") );
	if( answer == KMessageBox::Cancel ) {
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	KConfig config( fileName, true, false, "HOME" );
	// First we fetch some global settings
	config.setGroup( QString::fromLatin1("_config_") );
	QString email = config.readEntry( QString::fromLatin1("MAILADDR"), QString::fromLatin1("anonymous@") );	

	QStringList siteList = config.groupList();
	float size = (float)siteList.count();
	if( size == 0 ) {
		invalidFileError( fileName );
		m_hasError = true;
		emit progress( 100 );
		return;
	}	
	int counter = 0;
	const QString anonymStr = QString::fromLatin1("anonymous");
	for( QStringList::Iterator it = siteList.begin(); it != siteList.end(); ++it ) {
		QString siteName = *it; // found groupname from WS_FTP.ini

		QDomNode siteNode;
		QDomElement parentElement = m_domDocument.documentElement();
		config.setGroup( siteName );
		QString tmp = config.readEntry( QString::fromLatin1("HOST"), QString::null );  // we ignore the site if it hasn't any host
		if( tmp.isNull() )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
			tmp = config.readEntry( QString::fromLatin1("host"), QString::null );
		// first  check so the site has a host, if not ignore it
		if( ! tmp.isNull() || ! tmp.isEmpty() ) {  // had host
			// set label
			QDomElement siteElement = m_domDocument.createElement( TAG_SITE );
			siteElement.setAttribute( ATT_LABEL, siteName );			
			parentElement.appendChild( siteElement );	
			// set host
			QDomElement tmpElement = m_domDocument.createElement( TAG_HOST );
			QDomText txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set port
			tmpElement = m_domDocument.createElement( TAG_PORT );
			txtNode = m_domDocument.createTextNode( QString::number( 21 ) );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set protocol
			tmpElement = m_domDocument.createElement( TAG_PROTOCOL );
			txtNode = m_domDocument.createTextNode( QString::fromLatin1("ftp") );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set remote directory
			tmp = config.readEntry( QString::fromLatin1("DIR"), QString::fromLatin1("/") );  // we ignore the site if it hasn't any host
			if( tmp == QString::fromLatin1("/") )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				tmp = config.readEntry( QString::fromLatin1("dir"), QString::fromLatin1("/") );
			tmpElement = m_domDocument.createElement( TAG_REMOTE_PATH );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set local directory
			tmpElement = m_domDocument.createElement( TAG_LOCAL_PATH );
			txtNode = m_domDocument.createTextNode( QDir::homeDirPath() );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set username
			tmp = config.readEntry( QString::fromLatin1("UID"), anonymStr );  // we ignore the site if it hasn't any host
			if( tmp == anonymStr )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				tmp = config.readEntry( QString::fromLatin1("uid"), anonymStr );
			tmpElement = m_domDocument.createElement( TAG_USER );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set password
			if( tmp == anonymStr ) {
				tmp = encodePassword( email );
			}
			else {
				tmp = config.readEntry( QString::fromLatin1("PWD"), QString::null );  // we ignore the site if it hasn't any host
				if( tmp.isNull() )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
					tmp = config.readEntry( QString::fromLatin1("pwd"), QString::null );
			}
			tmpElement = m_domDocument.createElement( TAG_PASS );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set PASV
			int p = config.readNumEntry( QString::fromLatin1("PASVMODE"), 1 );  // we ignore the site if it hasn't any host
			if( p == 1 )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				p = config.readNumEntry( QString::fromLatin1("pasvmode"), 1 );
			if( p != 1 ) {
				tmpElement = m_domDocument.createElement( TAG_DISABLE_PASV );
				siteElement.appendChild( tmpElement );	
			}
			// set description
			tmp = config.readEntry( QString::fromLatin1("COMMENT"), QString::null );  // we ignore the site if it hasn't any host
			if( tmp.isNull() )               // it seem as WS_FTP mix uppercase/lowercase so we have to check for both
				tmp = config.readEntry( QString::fromLatin1("comment"), QString::null );
			tmpElement = m_domDocument.createElement( TAG_DESCRIPTION );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
		}
		emit progress( int(float(counter) / size * 100) );	
		counter++;	
	}	
	emit progress( 100 );
}
//-----------------------------------------------
void WS_FTPImportFilterPlugin::invalidFileError(const QString& fileName){
	KMessageBox::sorry( 0, i18n("The file: %1\nis either empty or it's not a valid WS_FTP bookmarks file.").arg(fileName), i18n("Invalid import file") );
}
//-----------------------------------------------
